/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.datagen;

import com.github.jarva.allthearcanistgear.AllTheArcanistGear;
import com.github.jarva.allthearcanistgear.common.items.armor.ArcanistArmorSet;
import com.github.jarva.allthearcanistgear.common.recipes.PerkTierIngredient;
import com.github.jarva.allthearcanistgear.datagen.ItemTagDatagen;
import com.github.jarva.allthearcanistgear.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class RecipeDatagen
extends RecipeProvider
implements IConditionBuilder {
    public RecipeDatagen(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(packOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput output) {
        RecipeOutput withATM = output.withConditions(new ICondition[]{this.modLoaded("allthemodium")});
        this.smithing(withATM, AddonItemRegistry.ALLTHEMODIUM, ItemTagDatagen.ALLTHEMODIUM_SMITHING_TEMPLATE, ItemTagDatagen.ALLTHEMODIUM_INGOT);
        this.smithing(withATM, AddonItemRegistry.VIBRANIUM, ItemTagDatagen.VIBRANIUM_SMITHING_TEMPLATE, AddonItemRegistry.ALLTHEMODIUM, ItemTagDatagen.VIBRANIUM_INGOT);
        this.smithing(withATM, AddonItemRegistry.UNOBTAINIUM, ItemTagDatagen.UNOBTAINIUM_SMITHING_TEMPLATE, AddonItemRegistry.VIBRANIUM, ItemTagDatagen.UNOBTAINIUM_INGOT);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AddonItemRegistry.CREATIVE).requires((ItemLike)ItemsRegistry.CREATIVE_SPELLBOOK).unlockedBy("has_creative_spellbook", RecipeDatagen.has((ItemLike)ItemsRegistry.CREATIVE_SPELLBOOK)).save(output);
    }

    private void smithing(RecipeOutput output, ArcanistArmorSet set, TagKey<Item> template, TagKey<Item> modifier) {
        ICondition elementalLoaded = this.modLoaded("ars_elemental");
        RecipeOutput withElemental = output.withConditions(new ICondition[]{elementalLoaded});
        this.smithing(withElemental, (Item)set.getHat(), template, ItemTagDatagen.ELEMENTAL_HAT, modifier, 0);
        this.smithing(withElemental, (Item)set.getChest(), template, ItemTagDatagen.ELEMENTAL_CHEST, modifier, 0);
        this.smithing(withElemental, (Item)set.getLegs(), template, ItemTagDatagen.ELEMENTAL_LEGS, modifier, 0);
        this.smithing(withElemental, (Item)set.getBoots(), template, ItemTagDatagen.ELEMENTAL_BOOTS, modifier, 0);
        RecipeOutput withoutElemental = output.withConditions(new ICondition[]{this.not(elementalLoaded)});
        this.smithing(withoutElemental, (Item)set.getHat(), template, ItemTagDatagen.BASE_HAT, modifier, 2);
        this.smithing(withoutElemental, (Item)set.getChest(), template, ItemTagDatagen.BASE_CHEST, modifier, 2);
        this.smithing(withoutElemental, (Item)set.getLegs(), template, ItemTagDatagen.BASE_LEGS, modifier, 2);
        this.smithing(withoutElemental, (Item)set.getBoots(), template, ItemTagDatagen.BASE_BOOTS, modifier, 2);
        this.smithing(output, (Item)set.getSpellbook(), template, (Item)ItemsRegistry.ARCHMAGE_SPELLBOOK.get(), modifier);
    }

    private Ingredient minArmorTier(TagKey<Item> base, int tier) {
        return tier > 0 ? new PerkTierIngredient(base, tier).toVanilla() : Ingredient.of(base);
    }

    private void smithing(RecipeOutput output, ArcanistArmorSet set, TagKey<Item> template, ArcanistArmorSet base, TagKey<Item> modifier) {
        this.smithing(output, (Item)set.getHat(), template, (Item)base.getHat(), modifier);
        this.smithing(output, (Item)set.getChest(), template, (Item)base.getChest(), modifier);
        this.smithing(output, (Item)set.getLegs(), template, (Item)base.getLegs(), modifier);
        this.smithing(output, (Item)set.getBoots(), template, (Item)base.getBoots(), modifier);
        this.smithing(output, (Item)set.getSpellbook(), template, (Item)base.getSpellbook(), modifier);
    }

    private void smithing(RecipeOutput output, Item armor, TagKey<Item> template, Item base, TagKey<Item> modifier) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of(template), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base}), (Ingredient)Ingredient.of(modifier), (RecipeCategory)RecipeCategory.COMBAT, (Item)armor).unlocks("allthearcanistgear:has_" + modifier.location().getPath() + "_ingot", RecipeDatagen.has(modifier)).save(output, this.r(RecipeDatagen.getItemName((ItemLike)armor) + "_smithing"));
    }

    private void smithing(RecipeOutput output, Item armor, TagKey<Item> template, TagKey<Item> base, TagKey<Item> modifier, int tier) {
        this.smithing(output, armor, template, this.minArmorTier(base, tier), modifier, base.location().getPath());
    }

    private void smithing(RecipeOutput output, Item item, TagKey<Item> template, Ingredient base, TagKey<Item> modifier, String baseName) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of(template), (Ingredient)base, (Ingredient)Ingredient.of(modifier), (RecipeCategory)RecipeCategory.COMBAT, (Item)item).unlocks("allthearcanistgear:has_" + modifier.location().getPath() + "_ingot", RecipeDatagen.has(modifier)).save(output, this.r(baseName + "_to_" + RecipeDatagen.getItemName((ItemLike)item) + "_smithing"));
    }

    private ResourceLocation r(String id) {
        return AllTheArcanistGear.prefix(id);
    }
}

