/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.feature.placement;

import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import sirttas.elementalcraft.world.feature.placement.ECPlacements;

public class SourcePlacement
extends PlacementModifier {
    public static final String NAME = "source";
    public static final SourcePlacement INSTANCE = new SourcePlacement();
    public static final MapCodec<SourcePlacement> CODEC = MapCodec.unit((Object)((Object)INSTANCE));

    private SourcePlacement() {
    }

    public static int getHeight(LevelAccessor level, int x, int z) {
        int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        if (y < level.getMaxBuildHeight()) {
            return Math.max(level.getSeaLevel(), y) + level.getRandom().nextInt(4);
        }
        return 0;
    }

    private int getHeight(PlacementContext helper, int x, int z) {
        int h = SourcePlacement.getHeight((LevelAccessor)helper.getLevel(), x, z);
        return Math.min(h, helper.getGenDepth());
    }

    @Nonnull
    public Stream<BlockPos> getPositions(PlacementContext helper, @Nonnull RandomSource rand, BlockPos pos) {
        int z;
        WorldGenLevel level = helper.getLevel();
        int x = pos.getX();
        int y = this.getHeight(helper, x, z = pos.getZ());
        return y <= level.getSeaLevel() || y >= level.dimensionType().logicalHeight() ? Stream.of(new BlockPos[0]) : Stream.of(new BlockPos(x, y, z));
    }

    @Nonnull
    public PlacementModifierType<?> type() {
        return (PlacementModifierType)ECPlacements.SOURCE.get();
    }
}

