/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.feature.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.util.RandomSource;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.world.feature.config.IElementTypeFeatureConfig;

public class RandomElementTypeFeatureConfig
implements IElementTypeFeatureConfig {
    public static final MapCodec<RandomElementTypeFeatureConfig> CODEC = Codec.unboundedMap(ElementType.CODEC, (Codec)Codec.INT).fieldOf("element_type").xmap(RandomElementTypeFeatureConfig::new, c -> c.elementTypes);
    private final Map<ElementType, Integer> elementTypes;

    public RandomElementTypeFeatureConfig(Map<ElementType, Integer> elementTypes) {
        if (elementTypes.containsKey(ElementType.NONE)) {
            throw new IllegalArgumentException("elementTypes must not contain NONE!");
        }
        this.elementTypes = new EnumMap<ElementType, Integer>(elementTypes);
    }

    @Override
    public ElementType getElementType(RandomSource rand) {
        int roll = rand.nextInt(this.elementTypes.values().stream().mapToInt(i -> i).sum());
        for (Map.Entry<ElementType, Integer> entry : this.elementTypes.entrySet()) {
            int weight = entry.getValue();
            if (weight > roll) {
                return entry.getKey();
            }
            roll -= weight;
        }
        return ElementType.NONE;
    }

    @Override
    public String getName() {
        return "random";
    }
}

