/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.tag;

import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;

public class ECTags {
    private ECTags() {
    }

    public static class GameEvents {
        public static final TagKey<GameEvent> SYNTHESIZABLE_TO_AIR = GameEvents.createTag("synthesizable_to_air");

        private GameEvents() {
        }

        private static TagKey<GameEvent> createTag(String name) {
            return GameEvents.createTag("elementalcraft", name);
        }

        private static TagKey<GameEvent> createCommonTag(String name) {
            return GameEvents.createTag("c", name);
        }

        private static TagKey<GameEvent> createTag(String modId, String name) {
            return TagKey.create((ResourceKey)Registries.GAME_EVENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)name));
        }
    }

    public static class DamageTypes {
        public static final TagKey<DamageType> BYPASSES_DEFENSE_JEWELS = DamageTypes.createTag("bypasses_jewels/defense");
        public static final TagKey<DamageType> BYPASSES_ATTACK_JEWELS = DamageTypes.createTag("bypasses_jewels/attack");
        public static final TagKey<DamageType> BLOCKED_BY_TORTOISE_JEWEL = DamageTypes.createTag("blocked_by_tortoise_jewel");

        private DamageTypes() {
        }

        private static TagKey<DamageType> createTag(String name) {
            return DamageTypes.createTag("elementalcraft", name);
        }

        private static TagKey<DamageType> createCommonTag(String name) {
            return DamageTypes.createTag("c", name);
        }

        private static TagKey<DamageType> createTag(String modId, String name) {
            return TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)name));
        }
    }

    public static class Biomes {
        public static final TagKey<Biome> HAS_SOURCE_ALTAR = Biomes.createTag("has_structure/source_altar");
        public static final TagKey<Biome> HAS_INERT_CRYSTAL = Biomes.createTag("has_inert_crystal");
        public static final TagKey<Biome> HAS_SOURCE_ALL = Biomes.createTag("has_sources/all");
        public static final TagKey<Biome> HAS_SOURCE_ICY = Biomes.createTag("has_sources/icy");
        public static final TagKey<Biome> HAS_SOURCE_JUNGLE = Biomes.createTag("has_sources/jungle");
        public static final TagKey<Biome> HAS_SOURCE_MUSHROOM = Biomes.createTag("has_sources/mushroom");
        public static final TagKey<Biome> HAS_SOURCE_NETHER = Biomes.createTag("has_sources/nether");
        public static final TagKey<Biome> HAS_SOURCE_NETHER_ALL = Biomes.createTag("has_sources/nether/all");
        public static final TagKey<Biome> HAS_SOURCE_NETHER_FOREST = Biomes.createTag("has_sources/nether/forest");
        public static final TagKey<Biome> HAS_SOURCE_OCEAN = Biomes.createTag("has_sources/ocean");
        public static final TagKey<Biome> HAS_SOURCE_PLAIN = Biomes.createTag("has_sources/plain");
        public static final TagKey<Biome> HAS_SOURCE_WET = Biomes.createTag("has_sources/wet");
        public static final TagKey<Biome> HAS_SOURCE_DRY = Biomes.createTag("has_sources/dry");
        public static final TagKey<Biome> HAS_SOURCE_MOUNTAIN = Biomes.createTag("has_sources/mountain");
        public static final TagKey<Biome> HAS_SOURCE_HILL = Biomes.createTag("has_sources/hill");
        public static final TagKey<Biome> HAS_SOURCE_FOREST = Biomes.createTag("has_sources/forest");
        public static final TagKey<Biome> HAS_SOURCE_END = Biomes.createTag("has_sources/end");
        public static final TagKey<Biome> HAS_SOURCE_LUSH_CAVE = Biomes.createTag("has_sources/lush_cave");
        public static final TagKey<Biome> HAS_SOURCE_DRIPSTONE_CAVE = Biomes.createTag("has_sources/dripstone_cave");
        public static final TagKey<Biome> HAS_SOURCE_DEEP_DARK = Biomes.createTag("has_sources/deep_dark");
        public static final TagKey<Biome> HAS_SOURCE_UNDERGROUND = Biomes.createTag("has_sources/underground");
        public static final TagKey<Biome> HAS_SOURCE_SKY = Biomes.createTag("has_sources/sky");

        private Biomes() {
        }

        private static TagKey<Biome> createTag(String name) {
            return Biomes.createTag("elementalcraft", name);
        }

        private static TagKey<Biome> createCommonTag(String name) {
            return Biomes.createTag("c", name);
        }

        private static TagKey<Biome> createTag(String modId, String name) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)name));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> SOURCES = Blocks.createTag("sources");
        public static final TagKey<Block> PUREROCKS = Blocks.createTag("purerocks");
        public static final TagKey<Block> PIPES = Blocks.createTag("pipes");
        public static final TagKey<Block> SHRINES = Blocks.createTag("shrines");
        public static final TagKey<Block> SHRINE_UPGRADES = Blocks.createTag("shrine_upgrades");
        public static final TagKey<Block> EXTRACTORS = Blocks.createTag("extractors");
        public static final TagKey<Block> SYNTHESIZERS = Blocks.createTag("synthesizers");
        public static final TagKey<Block> INSTRUMENTS = Blocks.createTag("instruments");
        public static final TagKey<Block> CONTAINER_TOOLS = Blocks.createTag("container_tools");
        public static final TagKey<Block> SMALL_CONTAINER_TOOLS = Blocks.createTag("container_tools/small");
        public static final TagKey<Block> FIRE_CONTAINER_TOOLS = Blocks.createTag("container_tools/fire");
        public static final TagKey<Block> WATER_CONTAINER_TOOLS = Blocks.createTag("container_tools/water");
        public static final TagKey<Block> EARTH_CONTAINER_TOOLS = Blocks.createTag("container_tools/earth");
        public static final TagKey<Block> AIR_CONTAINER_TOOLS = Blocks.createTag("container_tools/air");
        public static final TagKey<Block> PEDESTALS = Blocks.createTag("pedestals");
        public static final TagKey<Block> RUNE_AFFECTED_SPEED = Blocks.createTag("rune_affected/speed");
        public static final TagKey<Block> RUNE_AFFECTED_PRESERVATION = Blocks.createTag("rune_affected/preservation");
        public static final TagKey<Block> RUNE_AFFECTED_OPTIMIZATION = Blocks.createTag("rune_affected/optimization");
        public static final TagKey<Block> RUNE_AFFECTED_LUCK = Blocks.createTag("rune_affected/luck");
        public static final TagKey<Block> RUNE_AFFECTED_TZEENTCH = Blocks.createTag("rune_affected/tzeentch");
        public static final TagKey<Block> RUNE_AFFECTED_RANGE = Blocks.createTag("rune_affected/range");
        public static final TagKey<Block> CULTIVABLE_TALL_PLANTS = Blocks.createTag("cultivable_tall_plants");
        public static final TagKey<Block> SHRINES_MELTING_LIQUIFIABLES_LAVA = Blocks.createTag("shrines/melting/liquifiables/lava");
        public static final TagKey<Block> SHRINES_MELTING_LIQUIFIABLES_WATER = Blocks.createTag("shrines/melting/liquifiables/water");
        public static final TagKey<Block> SHRINES_GROWTH_BLACKLIST = Blocks.createTag("shrines/growth/blacklist");
        public static final TagKey<Block> SHRINES_GROWTH_BONELESS = Blocks.createTag("shrines/growth/boneless");
        public static final TagKey<Block> SHRINES_ORE_HARVESTABLE_CRYSTALS = Blocks.createTag("shrines/ore/harvestable_crystals");
        public static final TagKey<Block> SHRINES_HARVEST_HARVESTABLE_TALL_PLANTS = Blocks.createTag("shrines/harvest/harvestable_tall_plants");
        public static final TagKey<Block> SHRINES_UPGRADABLES_ACCELERATION = Blocks.createTag("shrines/upgradables/acceleration");
        public static final TagKey<Block> SHRINES_UPGRADABLES_RANGE = Blocks.createTag("shrines/upgradables/range");
        public static final TagKey<Block> SHRINES_UPGRADABLES_STRENGTH = Blocks.createTag("shrines/upgradables/strength");
        public static final TagKey<Block> SHRINES_UPGRADABLES_PROTECTION = Blocks.createTag("shrines/upgradables/protection");
        public static final TagKey<Block> SHRINES_UPGRADABLES_PLANTING = Blocks.createTag("shrines/upgradables/planting");
        public static final TagKey<Block> SHRINES_UPGRADABLES_FORTUNE = Blocks.createTag("shrines/upgradables/fortune");
        public static final TagKey<Block> SHRINES_UPGRADABLES_SILK_TOUCH = Blocks.createTag("shrines/upgradables/silk_touch");
        public static final TagKey<Block> SHRINES_UPGRADABLES_CRYSTAL_HARVEST = Blocks.createTag("shrines/upgradables/crystal_harvest");
        public static final TagKey<Block> SHRINES_UPGRADABLES_SILK_TOUCH_ATTACHED = Blocks.createTag("shrines/upgradables/silk_touch/attached");
        public static final TagKey<Block> TREE_PARTS = Blocks.createTag("tree_parts");
        public static final TagKey<Block> STORAGE_BLOCKS_DRENCHED_IRON = Blocks.createCommonTag("storage_blocks/drenched_iron");
        public static final TagKey<Block> STORAGE_BLOCKS_SWIFT_ALLOY = Blocks.createCommonTag("storage_blocks/swift_alloy");
        public static final TagKey<Block> STORAGE_BLOCKS_FIREITE = Blocks.createCommonTag("storage_blocks/fireite");
        public static final TagKey<Block> ORES_INERT_CRYSTAL = Blocks.createCommonTag("ores/inert_crystal");
        public static final TagKey<Block> BUDDING = Blocks.createCommonTag("budding");
        public static final TagKey<Block> BUDS = Blocks.createCommonTag("buds");
        public static final TagKey<Block> CLUSTERS = Blocks.createCommonTag("clusters");
        public static final TagKey<Block> BAG_OF_YURTING_BLACKLIST = Blocks.createTag("bagofyurting", "blacklist");
        public static final TagKey<Block> STRIPPED_OAK = Blocks.createTag("stripped_oak");
        public static final TagKey<Block> STRIPPED_DARK_OAK = Blocks.createTag("stripped_dark_oak");
        public static final TagKey<Block> STRIPPED_BIRCH = Blocks.createTag("stripped_birch");
        public static final TagKey<Block> STRIPPED_ACACIA = Blocks.createTag("stripped_acacia");
        public static final TagKey<Block> STRIPPED_JUNGLE = Blocks.createTag("stripped_jungle");
        public static final TagKey<Block> STRIPPED_SPRUCE = Blocks.createTag("stripped_spruce");
        public static final TagKey<Block> STRIPPED_MANGROVE = Blocks.createTag("stripped_mangrove");
        public static final TagKey<Block> STRIPPED_CRIMSON = Blocks.createTag("stripped_crimson");
        public static final TagKey<Block> STRIPPED_WARPED = Blocks.createTag("stripped_warped");
        public static final TagKey<Block> STRIPPED_CHERRY = Blocks.createTag("stripped_cherry");
        public static final TagKey<Block> STRIPPED_BAMBOO = Blocks.createTag("stripped_bamboo");

        private Blocks() {
        }

        private static TagKey<Block> createTag(String name) {
            return Blocks.createTag("elementalcraft", name);
        }

        private static TagKey<Block> createCommonTag(String name) {
            return Blocks.createTag("c", name);
        }

        private static TagKey<Block> createTag(String modId, String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)name));
        }

        public static HolderSet.Named<Block> getTag(ResourceLocation loc) {
            return Blocks.getTag((TagKey<Block> t) -> t.location().equals((Object)loc));
        }

        public static HolderSet.Named<Block> getTag(TagKey<Block> key) {
            return Blocks.getTag((TagKey<Block> t) -> t.equals((Object)key));
        }

        public static HolderSet.Named<Block> getTag(Predicate<TagKey<Block>> predicate) {
            return BuiltInRegistries.BLOCK.getTags().filter(p -> predicate.test((TagKey)p.getFirst())).map(Pair::getSecond).findFirst().orElse(null);
        }
    }

    public static class Items {
        public static final TagKey<Item> SPELL_CAST_TOOLS = Items.createTag("spell_cast_tools");
        public static final TagKey<Item> INFUSABLE_FOCUS = Items.createTag("infusable/focus");
        public static final TagKey<Item> INFUSABLE_STAVES = Items.createTag("infusable/staves");
        public static final TagKey<Item> INFUSABLE_SWORDS = Items.createTag("infusable/swords");
        public static final TagKey<Item> INFUSABLE_PICKAXES = Items.createTag("infusable/pickaxes");
        public static final TagKey<Item> INFUSABLE_AXES = Items.createTag("infusable/axes");
        public static final TagKey<Item> INFUSABLE_SHOVELS = Items.createTag("infusable/shovels");
        public static final TagKey<Item> INFUSABLE_HOES = Items.createTag("infusable/hoes");
        public static final TagKey<Item> INFUSABLE_PAXELS = Items.createTag("infusable/paxels");
        public static final TagKey<Item> INFUSABLE_SHILDS = Items.createTag("infusable/shields");
        public static final TagKey<Item> INFUSABLE_BOWS = Items.createTag("infusable/bows");
        public static final TagKey<Item> INFUSABLE_CROSSBOWS = Items.createTag("infusable/crossbows");
        public static final TagKey<Item> INFUSABLE_FISHING_RODS = Items.createTag("infusable/fishing_rods");
        public static final TagKey<Item> INFUSABLE_TRIDENTS = Items.createTag("infusable/tridents");
        public static final TagKey<Item> INFUSABLE_HELMETS = Items.createTag("infusable/helmets");
        public static final TagKey<Item> INFUSABLE_CHESTPLATES = Items.createTag("infusable/chestplates");
        public static final TagKey<Item> INFUSABLE_LEGGINGS = Items.createTag("infusable/leggings");
        public static final TagKey<Item> INFUSABLE_BOOTS = Items.createTag("infusable/boots");
        public static final TagKey<Item> CHISELS = Items.createTag("chisels");
        public static final TagKey<Item> SPELL_HOLDERS = Items.createTag("spell_holders");
        public static final TagKey<Item> ELEMENTAL_CRYSTALS = Items.createTag("crystals/elemental");
        public static final TagKey<Item> CRYSTALS = Items.createTag("crystals");
        public static final TagKey<Item> LENSES = Items.createTag("lenses");
        public static final TagKey<Item> RECEPTACLES = Items.createTag("receptacles");
        public static final TagKey<Item> EMPTY_RECEPTACLES = Items.createTag("receptacles/empty");
        public static final TagKey<Item> FULL_RECEPTACLES = Items.createTag("receptacles/full");
        public static final TagKey<Item> RUNE_SLATES = Items.createTag("rune_slates");
        public static final TagKey<Item> PUREROCKS = Items.createTag("purerocks");
        public static final TagKey<Item> PIPES = Items.createTag("pipes");
        public static final TagKey<Item> PIPES_UPGRADES = Items.createTag("pipes_upgrades");
        public static final TagKey<Item> PIPE_COVER_HIDING = Items.createTag("pipe_cover_hiding");
        public static final TagKey<Item> SHRINES = Items.createTag("shrines");
        public static final TagKey<Item> SHRINE_UPGRADES = Items.createTag("shrine_upgrades");
        public static final TagKey<Item> INSTRUMENTS = Items.createTag("instruments");
        public static final TagKey<Item> ENCHANTMENT_HOLDER = Items.createTag("enchantment_holder");
        public static final TagKey<Item> STAFF_CRAFT_SWORD = Items.createTag("staff_craft_sword");
        public static final TagKey<Item> PURE_ORES_SOURCES = Items.createTag("pure_ores/sources");
        public static final TagKey<Item> PURE_ORES_SOURCES_ORES = Items.createTag("pure_ores/sources/ores");
        public static final TagKey<Item> PURE_ORES_SOURCES_RAW_MATERIALS = Items.createTag("pure_ores/sources/raw_materials");
        public static final TagKey<Item> PURE_ORES_SOURCES_RAW_MATERIAL_BLOCKS = Items.createTag("pure_ores/sources/raw_material_blocks");
        public static final TagKey<Item> PURE_ORES_SOURCES_GEORE_SHARDS = Items.createTag("pure_ores/sources/geore_shards");
        public static final TagKey<Item> PURE_ORES_SOURCES_GEORE_BLOCKS = Items.createTag("pure_ores/sources/geore_blocks");
        public static final TagKey<Item> PURE_ORES_SOURCES_RESONANT_ORE = Items.createTag("pure_ores/sources/resonant_ore");
        public static final TagKey<Item> PURE_ORES_SOURCES_RAW_URANINITE = Items.createTag("pure_ores/sources/raw_uraninite");
        public static final TagKey<Item> PURE_ORES_SOURCES_POOR_URANINITE = Items.createTag("pure_ores/sources/poor_uraninite");
        public static final TagKey<Item> PURE_ORES_SOURCES_URANINITE = Items.createTag("pure_ores/sources/uraninite");
        public static final TagKey<Item> PURE_ORES_SOURCES_DENSE_URANINITE = Items.createTag("pure_ores/sources/dense_uraninite");
        public static final TagKey<Item> PURE_ORES_SPECIFICS = Items.createTag("pure_ores/specifics");
        public static final TagKey<Item> JEWELS = Items.createTag("jewels");
        public static final TagKey<Item> JEWEL_SOCKETABLES = Items.createTag("jewel_socketables");
        public static final TagKey<Item> SOURCE_SEEDS = Items.createTag("source_seeds");
        public static final TagKey<Item> GROVE_SHRINE_FLOWERS = Items.createTag("grove_shrine_flowers");
        public static final TagKey<Item> GROVE_SHRINE_BLACKLIST = Items.createTag("grove_shrine_blacklist");
        public static final TagKey<Item> MYSTICAL_GROVE_FLOWERS = Items.createTag("mystical_grove_flowers");
        public static final TagKey<Item> INGOTS_DRENCHED_IRON = Items.createCommonTag("ingots/drenched_iron");
        public static final TagKey<Item> INGOTS_SWIFT_ALLOY = Items.createCommonTag("ingots/swift_alloy");
        public static final TagKey<Item> INGOTS_FIREITE = Items.createCommonTag("ingots/fireite");
        public static final TagKey<Item> NUGGETS_DRENCHED_IRON = Items.createCommonTag("nuggets/drenched_iron");
        public static final TagKey<Item> NUGGETS_SWIFT_ALLOY = Items.createCommonTag("nuggets/swift_alloy");
        public static final TagKey<Item> NUGGETS_FIREITE = Items.createCommonTag("nuggets/fireite");
        public static final TagKey<Item> STORAGE_BLOCKS_DRENCHED_IRON = Items.createCommonTag("storage_blocks/drenched_iron");
        public static final TagKey<Item> STORAGE_BLOCKS_SWIFT_ALLOY = Items.createCommonTag("storage_blocks/swift_alloy");
        public static final TagKey<Item> STORAGE_BLOCKS_FIREITE = Items.createCommonTag("storage_blocks/fireite");
        public static final TagKey<Item> STORAGE_BLOCKS_RAW_MATERIALS = Items.createCommonTag("storage_blocks/raw_materials");
        public static final TagKey<Item> ORES_INERT_CRYSTAL = Items.createCommonTag("ores/inert_crystal");
        public static final TagKey<Item> HARDENED_RODS = Items.createCommonTag("rods/hardened");
        public static final TagKey<Item> TOOLS_PAXELS = Items.createCommonTag("tools/paxels");
        public static final TagKey<Item> TOOLS_AIOTS = Items.createCommonTag("tools/aiots");
        public static final TagKey<Item> CURIOS_ELEMENT_HOLDER = Items.createTag("curios", "element_holder");
        public static final TagKey<Item> STRIPPED_OAK = Items.createTag("stripped_oak");
        public static final TagKey<Item> STRIPPED_DARK_OAK = Items.createTag("stripped_dark_oak");
        public static final TagKey<Item> STRIPPED_BIRCH = Items.createTag("stripped_birch");
        public static final TagKey<Item> STRIPPED_ACACIA = Items.createTag("stripped_acacia");
        public static final TagKey<Item> STRIPPED_JUNGLE = Items.createTag("stripped_jungle");
        public static final TagKey<Item> STRIPPED_SPRUCE = Items.createTag("stripped_spruce");
        public static final TagKey<Item> STRIPPED_MANGROVE = Items.createTag("stripped_mangrove");
        public static final TagKey<Item> STRIPPED_CRIMSON = Items.createTag("stripped_crimson");
        public static final TagKey<Item> STRIPPED_WARPED = Items.createTag("stripped_warped");
        public static final TagKey<Item> STRIPPED_CHERRY = Items.createTag("stripped_cherry");
        public static final TagKey<Item> STRIPPED_BAMBOO = Items.createTag("stripped_bamboo");
        public static final TagKey<Item> WHITE_FLOWERS = Items.createCommonTag("flowers/white");
        public static final TagKey<Item> ORANGE_FLOWERS = Items.createCommonTag("flowers/orange");
        public static final TagKey<Item> MAGENTA_FLOWERS = Items.createCommonTag("flowers/magenta");
        public static final TagKey<Item> LIGHT_BLUE_FLOWERS = Items.createCommonTag("flowers/light_blue");
        public static final TagKey<Item> YELLOW_FLOWERS = Items.createCommonTag("flowers/yellow");
        public static final TagKey<Item> LIME_FLOWERS = Items.createCommonTag("flowers/lime");
        public static final TagKey<Item> PINK_FLOWERS = Items.createCommonTag("flowers/pink");
        public static final TagKey<Item> GRAY_FLOWERS = Items.createCommonTag("flowers/gray");
        public static final TagKey<Item> LIGHT_GRAY_FLOWERS = Items.createCommonTag("flowers/light_gray");
        public static final TagKey<Item> CYAN_FLOWERS = Items.createCommonTag("flowers/cyan");
        public static final TagKey<Item> PURPLE_FLOWERS = Items.createCommonTag("flowers/purple");
        public static final TagKey<Item> BLUE_FLOWERS = Items.createCommonTag("flowers/blue");
        public static final TagKey<Item> BROWN_FLOWERS = Items.createCommonTag("flowers/brown");
        public static final TagKey<Item> GREEN_FLOWERS = Items.createCommonTag("flowers/green");
        public static final TagKey<Item> BLACK_FLOWERS = Items.createCommonTag("flowers/black");
        public static final TagKey<Item> RED_FLOWERS = Items.createCommonTag("flowers/red");

        private Items() {
        }

        private static TagKey<Item> createTag(String name) {
            return Items.createTag("elementalcraft", name);
        }

        private static TagKey<Item> createTag(String namespace, String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)name));
        }

        private static TagKey<Item> createCommonTag(String name) {
            return Items.createTag("c", name);
        }

        public static HolderSet.Named<Item> getTag(ResourceLocation loc) {
            return Items.getTag((TagKey<Item> t) -> t.location().equals((Object)loc));
        }

        public static HolderSet.Named<Item> getTag(TagKey<Item> key) {
            return Items.getTag((TagKey<Item> t) -> t.equals((Object)key));
        }

        public static HolderSet.Named<Item> getTag(Predicate<TagKey<Item>> predicate) {
            return BuiltInRegistries.ITEM.getTags().filter(p -> predicate.test((TagKey)p.getFirst())).map(Pair::getSecond).findFirst().orElse(null);
        }
    }
}

