/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.water;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import sirttas.elementalcraft.spell.Spell;

public class RipeningSpell
extends Spell {
    public static final String NAME = "ripening";

    public RipeningSpell(ResourceKey<Spell> key) {
        super(key);
    }

    @Override
    @Nonnull
    public InteractionResult castOnBlock(@Nonnull Entity sender, @Nonnull BlockPos target, @Nonnull BlockHitResult hitResult) {
        BonemealableBlock growable;
        Level level = sender.level();
        BlockState state = level.getBlockState(target);
        Block block = state.getBlock();
        if (block instanceof BonemealableBlock && (growable = (BonemealableBlock)block).isBonemealSuccess(level, level.random, target, state)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 10 && growable.isValidBonemealTarget((LevelReader)level, target, state); ++i) {
                    growable.performBonemeal(serverLevel, level.random, target, state);
                    state = level.getBlockState(target);
                }
                level.levelEvent(1505, target, 0);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

