/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.water;

import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import sirttas.elementalcraft.spell.Spell;

public class PurificationSpell
extends Spell {
    public static final String NAME = "purification";

    public PurificationSpell(ResourceKey<Spell> key) {
        super(key);
    }

    private InteractionResult cureEffects(Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if (!target.level().isClientSide) {
                Iterator itr = livingTarget.getActiveEffects().iterator();
                while (itr.hasNext()) {
                    MobEffectInstance effect = (MobEffectInstance)itr.next();
                    Set cures = effect.getCures();
                    if (cures.isEmpty() || ((MobEffect)effect.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL || !((MobEffectEvent.Remove)NeoForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove(livingTarget, effect, (EffectCure)cures.iterator().next()))).isCanceled()) continue;
                    livingTarget.onEffectRemoved(effect);
                    itr.remove();
                    livingTarget.updateEffectVisibility();
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nonnull
    public InteractionResult castOnEntity(@Nonnull Entity caster, @Nonnull Entity target) {
        return this.cureEffects(target);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        return this.cureEffects(caster);
    }
}

