/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.tick;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.Spells;
import sirttas.elementalcraft.spell.tick.AbstractSpellInstance;
import sirttas.elementalcraft.spell.tick.ISpellTickManager;
import sirttas.elementalcraft.spell.tick.SpellCooldown;

public class SpellTickManager
implements ISpellTickManager,
INBTSerializable<CompoundTag> {
    private long tick;
    private final List<AbstractSpellInstance> spellInstances = new ArrayList<AbstractSpellInstance>();
    private final Map<Spell, SpellCooldown> spellCooldowns = new HashMap<Spell, SpellCooldown>();

    @Override
    @Nonnull
    public List<AbstractSpellInstance> getSpellInstances() {
        return List.copyOf(this.spellInstances);
    }

    @Override
    public void addSpellInstance(AbstractSpellInstance instance) {
        this.spellInstances.add(instance);
    }

    @Override
    public void startCooldown(Spell spell) {
        this.spellCooldowns.put(spell, new SpellCooldown(this.tick, this.tick + (long)spell.getCooldown()));
    }

    @Override
    public float getCooldown(Spell spell, float partialTick) {
        if (spell.isValid() && this.spellCooldowns.containsKey(spell)) {
            SpellCooldown cooldown = this.spellCooldowns.get(spell);
            float current = (float)cooldown.expireTicks() - ((float)this.tick + partialTick);
            long total = cooldown.expireTicks() - cooldown.createTicks();
            return current / (float)total;
        }
        return 0.0f;
    }

    @Override
    public void tick() {
        ++this.tick;
        this.spellCooldowns.values().removeIf(c -> c.expireTicks() <= this.tick);
        if (this.spellCooldowns.isEmpty()) {
            this.tick = 0L;
        }
        this.spellInstances.removeIf(AbstractSpellInstance::isFinished);
        this.spellInstances.forEach(i -> {
            i.tick();
            i.decTick();
        });
        this.spellInstances.removeIf(AbstractSpellInstance::isFinished);
    }

    @NotNull
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.spellCooldowns.forEach((spell, cooldown) -> tag.putLong(spell.getKey().toString(), cooldown.expireTicks() - this.tick));
        return tag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        this.spellCooldowns.clear();
        nbt.getAllKeys().forEach(key -> this.spellCooldowns.put((Spell)Spells.REGISTRY.get(ElementalCraftApi.createRL(key)), new SpellCooldown(this.tick, this.tick + nbt.getLong(key))));
    }
}

