/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.tick;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.tick.AbstractSpellInstance;
import sirttas.elementalcraft.spell.tick.ISpellTickManager;

public class SpellTickHelper {
    private SpellTickHelper() {
    }

    @Nullable
    public static ISpellTickManager get(@Nullable Entity entity) {
        return entity != null ? (ISpellTickManager)entity.getCapability(ISpellTickManager.CAPABILITY) : null;
    }

    @Nonnull
    public static List<AbstractSpellInstance> getSpellInstances(@Nullable Entity entity) {
        ISpellTickManager manager = SpellTickHelper.get(entity);
        if (manager == null) {
            return Collections.emptyList();
        }
        return manager.getSpellInstances();
    }

    public static void startCooldown(@Nullable Entity entity, Spell spell) {
        ISpellTickManager manager = SpellTickHelper.get(entity);
        if (manager != null) {
            manager.startCooldown(spell);
        }
    }

    public static boolean hasCooldown(@Nullable Entity entity, Spell spell) {
        ISpellTickManager manager = SpellTickHelper.get(entity);
        return manager != null && manager.hasCooldown(spell);
    }

    public static float getCooldown(@Nullable Entity entity, Spell spell, float frameTime) {
        ISpellTickManager manager = SpellTickHelper.get(entity);
        return manager != null ? manager.getCooldown(spell, frameTime) : 0.0f;
    }

    @Nullable
    public static AbstractSpellInstance getSpellInstance(@Nullable Entity entity, Spell spell) {
        ISpellTickManager manager = SpellTickHelper.get(entity);
        return manager != null ? manager.getSpellInstance(spell) : null;
    }
}

