/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.tick;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.network.payload.PayloadHelper;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.Spells;
import sirttas.elementalcraft.spell.tick.SpellTickHelper;

public record SpellTickCooldownPayload(Spell spell) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SpellTickCooldownPayload> TYPE = PayloadHelper.createType("spell_tick_cooldown");
    public static final StreamCodec<FriendlyByteBuf, SpellTickCooldownPayload> STREAM_CODEC = StreamCodec.of((b, p) -> p.write((FriendlyByteBuf)b), SpellTickCooldownPayload::new);

    public SpellTickCooldownPayload(FriendlyByteBuf buf) {
        this((Spell)Spells.REGISTRY.get(buf.readResourceLocation()));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.spell.getKey());
    }

    @NotNull
    public CustomPacketPayload.Type<SpellTickCooldownPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext payloadContext) {
        payloadContext.enqueueWork(() -> SpellTickHelper.startCooldown((Entity)payloadContext.player(), this.spell));
    }
}

