/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.tick;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.capabilities.EntityCapability;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.tick.AbstractSpellInstance;

public interface ISpellTickManager {
    public static final EntityCapability<ISpellTickManager, Void> CAPABILITY = EntityCapability.createVoid((ResourceLocation)ElementalCraftApi.createRL("spell_tick_manager"), ISpellTickManager.class);

    @Nullable
    default public AbstractSpellInstance getSpellInstance(Spell spell) {
        return this.getSpellInstances().stream().filter(spellInstance -> spellInstance.getSpell().equals(spell)).findFirst().orElse(null);
    }

    @Nonnull
    public List<AbstractSpellInstance> getSpellInstances();

    public void addSpellInstance(AbstractSpellInstance var1);

    public void startCooldown(Spell var1);

    default public boolean hasCooldown(Spell spell) {
        return this.getCooldown(spell) > 0.0f;
    }

    default public float getCooldown(Spell spell) {
        return this.getCooldown(spell, 0.0f);
    }

    public float getCooldown(Spell var1, float var2);

    public void tick();
}

