/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.repair;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.renderer.ECRendererHelper;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.renderer.ISpellRenderer;
import sirttas.elementalcraft.spell.repair.RepairSpell;

public class RepairSpellRenderer
implements ISpellRenderer {
    private static final float HAMMER_INTERVAL = 6.5f;

    @Override
    public void render(Spell spell, Entity caster, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (caster instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)caster;
            HitResult ray = EntityHelper.rayTrace(caster);
            HitResult.Type rayType = ray.getType();
            if (rayType == HitResult.Type.BLOCK && ray instanceof BlockHitResult) {
                BlockHitResult blockRay = (BlockHitResult)ray;
                if (spell instanceof RepairSpell) {
                    RepairSpell repairSpell = (RepairSpell)spell;
                    BlockPos anvilPos = blockRay.getBlockPos().relative(blockRay.getDirection());
                    Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
                    Vec3 cameraPos = camera.getPosition();
                    PoseStack newStack = new PoseStack();
                    BlockState anvilState = RepairSpellRenderer.getAnvilState((Player)player, blockRay);
                    ItemStack itemToRepair = repairSpell.getItemToRepair((Player)player);
                    if (anvilState == null) {
                        return;
                    }
                    newStack.mulPose(Axis.XP.rotationDegrees(camera.getXRot()));
                    newStack.mulPose(Axis.YP.rotationDegrees(camera.getYRot() + 180.0f));
                    newStack.translate((double)anvilPos.getX() - cameraPos.x(), (double)anvilPos.getY() - cameraPos.y(), (double)anvilPos.getZ() - cameraPos.z());
                    ECRendererHelper.renderBatched(anvilState, newStack, buffer, caster.level(), anvilPos);
                    newStack.translate(0.5, 1.0, 0.5);
                    newStack.mulPose(((Direction)anvilState.getValue((Property)AnvilBlock.FACING)).getRotation());
                    if (itemToRepair.is((Item)ECItems.STAFF.get())) {
                        newStack.mulPose(Axis.XP.rotationDegrees(-45.0f));
                        newStack.translate(0.0, -0.3, 0.0);
                        newStack.mulPose(Axis.YP.rotationDegrees(15.0f));
                    }
                    ECRendererHelper.renderItem(itemToRepair, newStack, buffer, packedLight, OverlayTexture.NO_OVERLAY);
                }
            }
        }
    }

    @Override
    public void renderFirstPerson(Spell spell, LocalPlayer player, InteractionHand hand, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ISpellRenderer.super.renderFirstPerson(spell, player, hand, partialTicks, poseStack, buffer, packedLight);
        float useTicks = 40.0f - ((float)player.getUseItemRemainingTicks() - partialTicks + 1.0f) % 40.0f;
        float swing = useTicks < 19.5f ? useTicks % 6.5f / 6.5f : 0.0f;
        Minecraft.getInstance().gameRenderer.itemInHandRenderer.renderArmWithItem((AbstractClientPlayer)player, partialTicks, Mth.lerp((float)partialTicks, (float)player.xRotO, (float)player.getXRot()), InteractionHand.MAIN_HAND, swing, new ItemStack(ECItems.REPAIR_HAMMER), 0.0f, poseStack, buffer, packedLight);
    }

    @Nullable
    private static BlockState getAnvilState(Player player, BlockHitResult blockRay) {
        return Blocks.ANVIL.getStateForPlacement(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Blocks.ANVIL), blockRay));
    }

    @Override
    public boolean hideHand(InteractionHand hand) {
        return true;
    }
}

