/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.repair;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;

public class RepairSpell
extends Spell {
    public static final String NAME = "repair";

    public RepairSpell(ResourceKey<Spell> key) {
        super(key);
    }

    @Override
    @Nonnull
    public InteractionResult castOnBlock(@Nonnull Entity sender, @Nonnull BlockPos target, @Nonnull BlockHitResult hitResult) {
        Player player;
        ItemStack item;
        BlockPos offset = target.relative(hitResult.getDirection());
        if (!sender.level().getBlockState(offset).isAir() || FallingBlock.isFree((BlockState)sender.level().getBlockState(offset.below()))) {
            return InteractionResult.PASS;
        }
        if (sender instanceof Player && !(item = this.getItemToRepair(player = (Player)sender)).isEmpty() && item.isDamaged()) {
            this.repairPlayerItems(item);
            RepairSpell.playSound(offset, player);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public ItemStack getItemToRepair(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        if (SpellHelper.getSpell(mainHand) == this) {
            return offHand;
        }
        if (SpellHelper.getSpell(offHand) == this) {
            return mainHand;
        }
        return ItemStack.EMPTY;
    }

    private void repairPlayerItems(ItemStack stack) {
        stack.setDamageValue(stack.getDamageValue() - Math.min((int)(this.getStrength() * stack.getXpRepairRatio()), stack.getDamageValue()));
    }

    private static void playSound(BlockPos offset, Player player) {
        int useTicks = player.getUseItemRemainingTicks();
        if (useTicks > 0 && useTicks % 40 == 0) {
            player.level().levelEvent(player, 1030, offset, 0);
        }
    }
}

