/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.renderer;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.Spells;
import sirttas.elementalcraft.spell.airshield.AirShieldSpellRenderer;
import sirttas.elementalcraft.spell.flamecleave.FlameCleaveSpellRenderer;
import sirttas.elementalcraft.spell.renderer.ISpellRenderer;
import sirttas.elementalcraft.spell.repair.RepairSpellRenderer;

public class SpellRenderers {
    private static final Map<ResourceLocation, ISpellRenderer> SPELL_RENDERERS = new HashMap<ResourceLocation, ISpellRenderer>();

    private SpellRenderers() {
    }

    public static ISpellRenderer get(Spell spell) {
        return SPELL_RENDERERS.get(spell.getKey());
    }

    public static void register(DeferredHolder<Spell, ? extends Spell> spell, ISpellRenderer renderer) {
        SPELL_RENDERERS.put(spell.getId(), renderer);
    }

    static {
        SpellRenderers.register(Spells.FLAME_CLEAVE, new FlameCleaveSpellRenderer());
        SpellRenderers.register(Spells.AIR_SHIELD, new AirShieldSpellRenderer());
        SpellRenderers.register(Spells.REPAIR, new RepairSpellRenderer());
    }
}

