/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.flamecleave;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import sirttas.elementalcraft.renderer.ECRendererHelper;
import sirttas.elementalcraft.spell.renderer.ISpellInstanceRenderer;
import sirttas.elementalcraft.spell.tick.AbstractSpellInstance;

public class FlameCleaveSpellRenderer
implements ISpellInstanceRenderer {
    @Override
    public void render(AbstractSpellInstance spell, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Entity entity = spell.getCaster();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack weapon = livingEntity.getMainHandItem();
            float angle = ((float)spell.getTicks() + partialTicks) / (float)spell.getDuration() * 360.0f;
            poseStack.translate(0.0f, 1.0f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-angle));
            poseStack.translate(0.0f, 0.0f, 1.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
            ECRendererHelper.renderItem(weapon, poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY);
        }
    }

    @Override
    public void renderFirstPerson(AbstractSpellInstance instance, LocalPlayer caster, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.translate(0.0, -1.25, 0.0);
        ISpellInstanceRenderer.super.renderFirstPerson(instance, caster, partialTicks, poseStack, buffer, packedLight);
    }
}

