/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.fire;

import javax.annotation.Nonnull;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.spell.Spell;

public class InfernoSpell
extends Spell {
    public static final String NAME = "inferno";

    public InfernoSpell(ResourceKey<Spell> key) {
        super(key);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        Level level = caster.level();
        float range = this.getRange(caster);
        Vec3 look = caster.getLookAngle().normalize();
        if (caster instanceof LivingEntity) {
            LivingEntity livingSender = (LivingEntity)caster;
            for (LivingEntity target : level.getEntitiesOfClass(LivingEntity.class, caster.getBoundingBox().expandTowards(look.scale((double)(range + 1.0f))).inflate(1.0, 0.25, 1.0))) {
                DamageSource damageSource;
                ArmorStand stand;
                if (target == caster || caster.isAlliedTo((Entity)target) || target instanceof ArmorStand && (stand = (ArmorStand)target).isMarker() || !(caster.distanceToSqr((Entity)target) < (double)(range * range)) || !(this.getAngle(caster, (Entity)target) <= 30.0)) continue;
                DamageSources sources = caster.level().damageSources();
                if (caster instanceof Player) {
                    Player player = (Player)caster;
                    damageSource = sources.playerAttack(player);
                } else {
                    damageSource = sources.mobAttack(livingSender);
                }
                target.hurt(damageSource, this.getStrength());
                target.igniteForSeconds(1.0f);
            }
            int i = 0;
            while ((float)i < range) {
                Vec3 scaledLook = look.scale((double)i);
                level.levelEvent(null, 2004, livingSender.blockPosition().offset(new Vec3i((int)Math.round(scaledLook.x), (int)Math.round(scaledLook.y), (int)Math.round(scaledLook.z))), 0);
                ++i;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private double getAngle(Entity sender, Entity target) {
        Vec3 vec1 = sender.getLookAngle().normalize();
        Vec3 vec2 = target.position().subtract(sender.position()).normalize();
        return Math.acos(vec1.dot(vec2)) * 57.29577951308232;
    }
}

