/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.fire;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.spell.Spell;

public class FireBallSpell
extends Spell {
    public static final String NAME = "fireball";

    public FireBallSpell(ResourceKey<Spell> key) {
        super(key);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        if (!(caster instanceof LivingEntity)) {
            return InteractionResult.PASS;
        }
        LivingEntity livingEntity = (LivingEntity)caster;
        Vec3 vec3d = livingEntity.getLookAngle();
        LargeFireball fireball = new LargeFireball(livingEntity.level(), livingEntity, new Vec3(vec3d.x * 100.0, vec3d.y * 100.0, vec3d.z * 100.0), Math.round(this.getStrength()));
        fireball.setPos(livingEntity.getX() + vec3d.x * 4.0, livingEntity.getY(0.5) + 0.5, fireball.getZ() + vec3d.z * 4.0);
        livingEntity.level().addFreshEntity((Entity)fireball);
        return InteractionResult.SUCCESS;
    }
}

