/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.earth;

import java.util.ArrayDeque;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.tag.ECTags;

public class TreeFallSpell
extends Spell {
    public static final String NAME = "tree_fall";

    public TreeFallSpell(ResourceKey<Spell> key) {
        super(key);
    }

    private boolean isValidBlock(BlockState state) {
        return state.is(ECTags.Blocks.TREE_PARTS);
    }

    private void cutTree(Entity sender, Level level, BlockPos target) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        float rangeSq = this.getRange(sender);
        rangeSq *= rangeSq;
        queue.offer(target);
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            BlockState state = level.getBlockState(pos);
            if (!this.isValidBlock(state) || !(pos.distSqr((Vec3i)target) <= (double)rangeSq)) continue;
            level.destroyBlock(pos, true);
            Stream.of(Direction.values()).filter(d -> d != Direction.DOWN).forEach(d -> queue.offer(pos.relative(d)));
        }
    }

    @Override
    @Nonnull
    public InteractionResult castOnBlock(@Nonnull Entity sender, @Nonnull BlockPos target, @Nonnull BlockHitResult hitResult) {
        Level level = sender.level();
        if (!level.isClientSide && this.isValidBlock(level.getBlockState(target))) {
            this.cutTree(sender, level, target);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

