/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.earth;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import sirttas.elementalcraft.spell.Spell;

public class StoneWallSpell
extends Spell {
    public static final String NAME = "stonewall";

    public StoneWallSpell(ResourceKey<Spell> key) {
        super(key);
    }

    private void checkAndPlace(Level level, BlockPos pos) {
        if (level.getBlockState(pos).canBeReplaced()) {
            level.setBlockAndUpdate(pos, Blocks.STONE.defaultBlockState());
        }
    }

    public InteractionResult cast(Entity sender, BlockPos pos, Direction direction) {
        Level level = sender.level();
        this.checkAndPlace(level, pos);
        this.checkAndPlace(level, pos.relative(direction.getClockWise()));
        this.checkAndPlace(level, pos.relative(direction.getCounterClockWise()));
        this.checkAndPlace(level, pos.above(1));
        this.checkAndPlace(level, pos.above(2));
        this.checkAndPlace(level, pos.relative(direction.getClockWise()).above(1));
        this.checkAndPlace(level, pos.relative(direction.getClockWise()).above(2));
        this.checkAndPlace(level, pos.relative(direction.getCounterClockWise()).above(1));
        this.checkAndPlace(level, pos.relative(direction.getCounterClockWise()).above(2));
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        Optional<Direction> opt = Stream.of(Direction.orderedByNearest((Entity)caster)).filter(d -> d.getAxis() != Direction.Axis.Y).findFirst();
        if (opt.isEmpty()) {
            return InteractionResult.PASS;
        }
        return this.cast(caster, BlockPos.containing((Position)caster.position()).relative(opt.get(), 3), opt.get());
    }

    @Override
    public boolean consume(Entity sender, boolean simulate) {
        boolean value = this.consume(sender, (ItemLike)Blocks.STONE, 9, simulate);
        return super.consume(sender, simulate) && value;
    }

    @Override
    public void addInformation(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.consumes", (Object[])new Object[]{Component.translatable((String)"tooltip.elementalcraft.count", (Object[])new Object[]{9, Blocks.STONE.getName()})}).withStyle(ChatFormatting.YELLOW));
    }
}

