/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.earth;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import sirttas.elementalcraft.spell.Spell;

public class GavelFallSpell
extends Spell {
    public static final String NAME = "gravelfall";

    public GavelFallSpell(ResourceKey<Spell> key) {
        super(key);
    }

    private void spawn(Level level, BlockPos pos) {
        FallingBlockEntity entity = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)Blocks.GRAVEL.defaultBlockState());
        entity.time = 1;
        entity.setHurtsEntities(this.getStrength(), 100);
        level.addFreshEntity((Entity)entity);
    }

    private void checkAndSpawn(Level level, BlockPos pos) {
        if (level.isEmptyBlock(pos)) {
            this.spawn(level, pos);
        }
    }

    private InteractionResult spawnGravel(Entity sender, BlockPos pos) {
        Level level = sender.level();
        this.checkAndSpawn(level, pos.above(4));
        this.checkAndSpawn(level, pos.above(5));
        this.checkAndSpawn(level, pos.above(6));
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nonnull
    public InteractionResult castOnBlock(@Nonnull Entity sender, @Nonnull BlockPos target, @Nonnull BlockHitResult hitResult) {
        return this.spawnGravel(sender, target);
    }

    @Override
    @Nonnull
    public InteractionResult castOnEntity(@Nonnull Entity caster, @Nonnull Entity target) {
        return this.spawnGravel(caster, BlockPos.containing((Position)target.position()));
    }

    @Override
    public boolean consume(Entity sender, boolean simulate) {
        boolean value = this.consume(sender, (ItemLike)Blocks.GRAVEL, 3, simulate);
        return super.consume(sender, simulate) && value;
    }

    @Override
    public void addInformation(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.consumes", (Object[])new Object[]{Component.translatable((String)"tooltip.elementalcraft.count", (Object[])new Object[]{3, Blocks.GRAVEL.getName()})}).withStyle(ChatFormatting.YELLOW));
    }
}

