/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.air;

import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import sirttas.elementalcraft.block.anchor.TranslocationAnchorsSaveData;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;

public class TranslocationSpell
extends Spell {
    public static final String NAME = "translocation";

    public TranslocationSpell(ResourceKey<Spell> key) {
        super(key);
    }

    public static boolean isTranslocation(ItemStack stack) {
        return SpellHelper.getSpell(stack).is(Spells.TRANSLOCATION);
    }

    public static boolean holdsTranslocation(Player player) {
        return TranslocationSpell.isTranslocation(player.getMainHandItem()) || TranslocationSpell.isTranslocation(player.getOffhandItem());
    }

    public static BlockPos getTargetAnchor(Entity caster, Collection<BlockPos> anchors) {
        Vec3 playerPos = caster.getEyePosition();
        Vec3 playerLook = caster.getLookAngle().normalize();
        BlockPos target = null;
        double angle = 0.0;
        for (BlockPos pos : anchors) {
            double a = TranslocationSpell.getAngle(pos, playerPos, playerLook);
            if (!(a > 0.0) || !(a < 0.1308996938995747) || !(a < angle) && target != null) continue;
            angle = a;
            target = pos;
        }
        return target;
    }

    private static double getAngle(BlockPos pos, Vec3 playerPos, Vec3 playerLook) {
        return Math.acos(playerPos.vectorTo(Vec3.atBottomCenterOf((Vec3i)pos)).normalize().dot(playerLook));
    }

    private void teleport(Entity caster, Vec3 newPos) {
        caster.teleportTo(newPos.x, newPos.y, newPos.z);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        Vec3 look;
        Level level = caster.level();
        Vec3 newPos = this.getNewPos(caster, level, look = caster.getLookAngle());
        if (newPos == null) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide) {
            level.getChunk((int)Math.round(newPos.x / 16.0), (int)Math.round(newPos.z / 16.0));
            if (((Event)NeoForge.EVENT_BUS.post((net.neoforged.bus.api.Event)new Event(caster, newPos.x, newPos.y, newPos.z))).isCanceled()) {
                return InteractionResult.SUCCESS;
            }
            ParticleHelper.createEnderParticle(level, caster.position(), 3, level.random);
            ParticleHelper.createEnderParticle(level, newPos, 3, level.random);
            this.delay(caster, 10, () -> {
                if (caster instanceof LivingEntity) {
                    LivingEntity livingSender = (LivingEntity)caster;
                    Vec3 oldPos = caster.position();
                    this.teleport(caster, newPos);
                    level.playSound(null, oldPos.x, oldPos.y, oldPos.z, SoundEvents.ENDERMAN_TELEPORT, livingSender.getSoundSource(), 1.0f, 1.0f);
                    livingSender.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                } else {
                    this.teleport(caster, newPos);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    private Vec3 getNewPos(@Nonnull Entity caster, Level level, Vec3 look) {
        BlockPos target;
        TranslocationAnchorsSaveData list = TranslocationAnchorsSaveData.get(level);
        if (list != null && (target = TranslocationSpell.getTargetAnchor(caster, list.getAnchors())) != null) {
            return Vec3.atCenterOf((Vec3i)target);
        }
        Vec3 targetPos = caster.position().add(new Vec3(look.x(), 0.0, look.z()).normalize().scale((double)this.getRange(caster)));
        Vec3 newPos = new Vec3(targetPos.x(), this.getHeight(level, caster, targetPos), targetPos.z());
        if (newPos.y >= (double)level.dimensionType().logicalHeight() || newPos.y < (double)level.getSeaLevel()) {
            return null;
        }
        return newPos;
    }

    private double getHeight(Level level, Entity sender, Vec3 targetPos) {
        double height = (double)level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BlockPos.containing((Position)targetPos)).getY() + 1.0;
        if (!sender.onGround()) {
            return Math.max(height, sender.getY());
        }
        return height;
    }

    public static class Event
    extends EntityTeleportEvent {
        public Event(Entity entity, double targetX, double targetY, double targetZ) {
            super(entity, targetX, targetY, targetZ);
        }
    }
}

