/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.air;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.spell.Spell;

public class ItemPullSpell
extends Spell {
    public static final String NAME = "item_pull";

    public ItemPullSpell(ResourceKey<Spell> key) {
        super(key);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        Vec3 pos = caster.position();
        Level level = caster.level();
        level.getEntitiesOfClass(ItemEntity.class, new AABB(pos, pos.add(1.0, 1.0, 1.0)).inflate((double)this.getRange(caster))).forEach(i -> {
            if (level.isClientSide) {
                ParticleHelper.createEnderParticle(level, i.position(), 3, level.random);
            }
            i.setPos(pos.x, pos.y, pos.z);
        });
        return InteractionResult.SUCCESS;
    }
}

