/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.air;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.spell.Spell;

public class DashSpell
extends Spell {
    public static final String NAME = "dash";

    public DashSpell(ResourceKey<Spell> key) {
        super(key);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        LivingEntity livingEntity;
        float range = this.getRange(caster);
        if (caster.isPassenger()) {
            return InteractionResult.PASS;
        }
        if (caster instanceof LivingEntity && this.isFlying(livingEntity = (LivingEntity)caster)) {
            this.effect(caster, livingEntity.getRandom().nextInt(10, 20) + (int)Math.ceil(range), instance -> {
                if (this.isFlying(livingEntity)) {
                    Vec3 lookAngle = livingEntity.getLookAngle();
                    Vec3 movement = livingEntity.getDeltaMovement();
                    livingEntity.setDeltaMovement(movement.add(lookAngle.x * 0.1 + (lookAngle.x * 1.5 - movement.x) * 0.5, lookAngle.y * 0.1 + (lookAngle.y * 1.5 - movement.y) * 0.5, lookAngle.z * 0.1 + (lookAngle.z * 1.5 - movement.z) * 0.5));
                } else {
                    instance.stop();
                }
            });
        } else {
            caster.setDeltaMovement(caster.getDeltaMovement().add(caster.getLookAngle().normalize().scale((double)range)));
        }
        return InteractionResult.SUCCESS;
    }

    private boolean isFlying(LivingEntity livingEntity) {
        FlyingAnimal flyingAnimal;
        return livingEntity.isFallFlying() || livingEntity instanceof FlyingAnimal && (flyingAnimal = (FlyingAnimal)livingEntity).isFlying();
    }
}

