/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.spell.AoeSpell;
import sirttas.elementalcraft.spell.EffectSpell;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.air.DashSpell;
import sirttas.elementalcraft.spell.air.EnderStrikeSpell;
import sirttas.elementalcraft.spell.air.FeatherSpikesSpell;
import sirttas.elementalcraft.spell.air.ItemPullSpell;
import sirttas.elementalcraft.spell.air.TranslocationSpell;
import sirttas.elementalcraft.spell.airshield.AirShieldSpell;
import sirttas.elementalcraft.spell.earth.GavelFallSpell;
import sirttas.elementalcraft.spell.earth.SilkVeinSpell;
import sirttas.elementalcraft.spell.earth.StoneWallSpell;
import sirttas.elementalcraft.spell.earth.TreeFallSpell;
import sirttas.elementalcraft.spell.fire.FireBallSpell;
import sirttas.elementalcraft.spell.fire.InfernoSpell;
import sirttas.elementalcraft.spell.flamecleave.FlameCleaveSpell;
import sirttas.elementalcraft.spell.repair.RepairSpell;
import sirttas.elementalcraft.spell.water.AnimalGrowthSpell;
import sirttas.elementalcraft.spell.water.PurificationSpell;
import sirttas.elementalcraft.spell.water.RipeningSpell;

public class Spells {
    public static final ResourceKey<Registry<Spell>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ElementalCraftApi.createRL("spell"));
    private static final DeferredRegister<Spell> DEFERRED_REGISTER = DeferredRegister.create((ResourceLocation)ElementalCraftApi.createRL("spell"), (String)"elementalcraft");
    public static final Registry<Spell> REGISTRY = DEFERRED_REGISTER.makeRegistry(b -> b.sync(true).defaultKey(ElementalCraftApi.createRL("none")));
    public static final DeferredHolder<Spell, Spell> NONE = Spells.register("none", Spell::new);
    public static final DeferredHolder<Spell, GavelFallSpell> GRAVEL_FALL = Spells.register("gravelfall", GavelFallSpell::new);
    public static final DeferredHolder<Spell, StoneWallSpell> STONE_WALL = Spells.register("stonewall", StoneWallSpell::new);
    public static final DeferredHolder<Spell, FireBallSpell> FIRE_BALL = Spells.register("fireball", FireBallSpell::new);
    public static final DeferredHolder<Spell, ItemPullSpell> ITEM_PULL = Spells.register("item_pull", ItemPullSpell::new);
    public static final DeferredHolder<Spell, EnderStrikeSpell> ENDER_STRIKE = Spells.register("ender_strike", EnderStrikeSpell::new);
    public static final DeferredHolder<Spell, FlameCleaveSpell> FLAME_CLEAVE = Spells.register("flame_cleave", FlameCleaveSpell::new);
    public static final DeferredHolder<Spell, TranslocationSpell> TRANSLOCATION = Spells.register("translocation", TranslocationSpell::new);
    public static final DeferredHolder<Spell, DashSpell> DASH = Spells.register("dash", DashSpell::new);
    public static final DeferredHolder<Spell, SilkVeinSpell> SILK_VEIN = Spells.register("silk_vein", SilkVeinSpell::new);
    public static final DeferredHolder<Spell, AnimalGrowthSpell> ANIMAL_GROWTH = Spells.register("animal_growth", AnimalGrowthSpell::new);
    public static final DeferredHolder<Spell, RipeningSpell> RIPENING = Spells.register("ripening", RipeningSpell::new);
    public static final DeferredHolder<Spell, PurificationSpell> PURIFICATION = Spells.register("purification", PurificationSpell::new);
    public static final DeferredHolder<Spell, FeatherSpikesSpell> FEATHER_SPIKES = Spells.register("feather_spikes", k -> new FeatherSpikesSpell((ResourceKey<Spell>)k, 3));
    public static final DeferredHolder<Spell, TreeFallSpell> TREE_FALL = Spells.register("tree_fall", TreeFallSpell::new);
    public static final DeferredHolder<Spell, InfernoSpell> INFERNO = Spells.register("inferno", InfernoSpell::new);
    public static final DeferredHolder<Spell, EffectSpell> HEAL = Spells.register("heal", k -> new EffectSpell((ResourceKey<Spell>)k, new MobEffectInstance(MobEffects.HEAL, 1, 1)));
    public static final DeferredHolder<Spell, EffectSpell> SPEED = Spells.register("speed", k -> new EffectSpell((ResourceKey<Spell>)k, new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 2400, 1), new MobEffectInstance(MobEffects.DIG_SPEED, 2400)));
    public static final DeferredHolder<Spell, AoeSpell> SHOCKWAVE = Spells.register("shockwave", AoeSpell::new);
    public static final DeferredHolder<Spell, AirShieldSpell> AIR_SHIELD = Spells.register("air_shield", AirShieldSpell::new);
    public static final DeferredHolder<Spell, RepairSpell> REPAIR = Spells.register("repair", RepairSpell::new);

    private Spells() {
    }

    private static <T extends Spell> DeferredHolder<Spell, T> register(String name, Function<ResourceKey<Spell>, ? extends T> builder) {
        return DEFERRED_REGISTER.register(name, () -> (Spell)builder.apply(ResourceKey.create(REGISTRY_KEY, (ResourceLocation)ElementalCraftApi.createRL(name))));
    }

    public static void register(IEventBus modBus) {
        DEFERRED_REGISTER.register(modBus);
    }
}

