/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.Spells;

public class SpellList {
    public static final SpellList EMPTY = new SpellList(Map.of(), 0);
    public static final Codec<SpellList> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Spells.REGISTRY.holderByNameCodec(), (Codec)Codec.INT).fieldOf("spells").forGetter(l -> l.spells), (App)Codec.INT.fieldOf("max_spells").forGetter(l -> l.maxSpells)).apply((Applicative)instance, SpellList::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SpellList> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Object2IntOpenHashMap::new, (StreamCodec)ByteBufCodecs.holderRegistry(Spells.REGISTRY_KEY), (StreamCodec)ByteBufCodecs.VAR_INT), l -> l.spells, (StreamCodec)ByteBufCodecs.VAR_INT, l -> l.maxSpells, SpellList::new);
    private final Object2IntOpenHashMap<Holder<Spell>> spells;
    private final int maxSpells;

    private SpellList(Map<Holder<Spell>, Integer> spells, int maxSpells) {
        this.spells = new Object2IntOpenHashMap(spells);
        this.maxSpells = maxSpells;
    }

    public void forEachSpell(ObjIntConsumer<Holder<Spell>> consumer) {
        this.spells.forEach(consumer::accept);
    }

    public Mutable mutable() {
        return new Mutable(this);
    }

    public boolean isEmpty() {
        return this.spells.isEmpty();
    }

    public boolean isFull() {
        return this.count() >= this.maxSpells;
    }

    public int count() {
        return this.spells.values().intStream().sum();
    }

    public Map<Holder<Spell>, Integer> getSpells() {
        return Map.copyOf(this.spells);
    }

    public int getIndex(Holder<Spell> spell) {
        int index = 0;
        for (Holder spellHolder : this.spells.keySet()) {
            if (spellHolder == spell) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Holder<Spell> getSpellAt(int i) {
        int index = 0;
        for (Holder spell : this.spells.keySet()) {
            if (index == i) {
                return spell;
            }
            ++index;
        }
        return Spells.NONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpellList spellList = (SpellList)o;
        return this.maxSpells == spellList.maxSpells && Objects.equals(this.spells, spellList.spells);
    }

    public int hashCode() {
        return Objects.hash(this.spells, this.maxSpells);
    }

    public static class Mutable {
        private final Object2IntOpenHashMap<Holder<Spell>> spells;
        private int maxSpells;

        private Mutable(SpellList list) {
            this.spells = new Object2IntOpenHashMap(list.spells);
            this.maxSpells = list.maxSpells;
        }

        public Mutable maxSpells(int maxSpells) {
            this.maxSpells = maxSpells;
            return this;
        }

        public Mutable add(Holder<Spell> spell) {
            this.spells.compute(spell, (s, i) -> i == null ? 1 : i + 1);
            return this;
        }

        public Mutable remove(Holder<Spell> spell) {
            this.spells.compute(spell, (s, i) -> i == null ? 0 : i - 1);
            if (this.spells.getInt(spell) == 0) {
                this.spells.removeInt(spell);
            }
            return this;
        }

        public Mutable removeAll(Holder<Spell> spell) {
            this.spells.removeInt(spell);
            return this;
        }

        public Mutable clear() {
            this.spells.clear();
            return this;
        }

        public SpellList immutable() {
            return new SpellList((Map<Holder<Spell>, Integer>)this.spells, this.maxSpells);
        }
    }
}

