/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellList;
import sirttas.elementalcraft.spell.Spells;

public class SpellHelper {
    private SpellHelper() {
    }

    public static Holder<Spell> getSpell(ItemStack stack) {
        return (Holder)stack.getOrDefault(ECDataComponents.SPELL, Spells.NONE);
    }

    public static void setSpell(ItemStack stack, Holder<Spell> spell) {
        stack.set(ECDataComponents.SPELL, spell);
    }

    public static void removeSpell(ItemStack stack, Holder<Spell> spell) {
        SpellList list = SpellHelper.getSpellList(stack);
        if (list.isEmpty()) {
            return;
        }
        SpellList newList = list.mutable().remove(spell).immutable();
        stack.set(ECDataComponents.SPELL_LIST, (Object)newList);
        if (SpellHelper.getSpell(stack).is(spell)) {
            SpellHelper.setSpell(stack, newList.isEmpty() ? Spells.NONE : newList.getSpellAt(0));
        }
    }

    public static SpellList getSpellList(ItemStack stack) {
        return (SpellList)stack.getOrDefault(ECDataComponents.SPELL_LIST, (Object)SpellList.EMPTY);
    }

    public static void copySpells(ItemStack source, ItemStack target) {
        Holder<Spell> spell;
        SpellList list = SpellHelper.getSpellList(source);
        if (!list.isEmpty()) {
            target.set(ECDataComponents.SPELL_LIST, (Object)list.mutable().immutable());
        }
        if (SpellHelper.isValid(spell = SpellHelper.getSpell(source))) {
            SpellHelper.setSpell(target, spell);
        }
    }

    public static boolean isValid(Holder<Spell> spell) {
        return ((Spell)spell.value()).isValid();
    }

    public static boolean isVisible(Holder<Spell> spell) {
        return ((Spell)spell.value()).isVisible();
    }

    public static void addSpell(ItemStack stack, Holder<Spell> spell) {
        SpellList list = SpellHelper.getSpellList(stack);
        if (list.isFull()) {
            return;
        }
        SpellList newList = list.mutable().add(spell).immutable();
        stack.set(ECDataComponents.SPELL_LIST, (Object)newList);
        if (newList.count() == 1) {
            SpellHelper.setSpell(stack, spell);
        }
    }

    public static int getSelected(ItemStack stack) {
        SpellList list = SpellHelper.getSpellList(stack);
        if (list.isEmpty()) {
            return -1;
        }
        Holder<Spell> spell = SpellHelper.getSpell(stack);
        return list.getIndex(spell);
    }

    public static void setSelected(ItemStack stack, int i) {
        SpellList list = SpellHelper.getSpellList(stack);
        if (list.isEmpty()) {
            return;
        }
        SpellHelper.setSpell(stack, list.getSpellAt(i));
    }

    public static Holder<Spell> randomSpell(RandomSource rand) {
        return SpellHelper.randomSpell(Spells.REGISTRY.holders().toList(), rand);
    }

    public static Holder<Spell> randomSpell(ElementType type, RandomSource rand) {
        return SpellHelper.randomSpell(Spells.REGISTRY.holders().filter(spell -> {
            Spell value = (Spell)spell.value();
            return value.getElementType() == type && value.isValid();
        }).toList(), rand);
    }

    public static Holder<Spell> randomSpell(Iterable<? extends Holder<Spell>> spells, RandomSource rand) {
        List<Holder> list = StreamSupport.stream(spells.spliterator(), false).filter(SpellHelper::isValid).toList();
        if (list.isEmpty()) {
            return Spells.NONE;
        }
        int roll = rand.nextInt(list.stream().mapToInt(h -> ((Spell)h.value()).getWeight()).sum());
        for (Holder spell : list) {
            if ((roll -= ((Spell)spell.value()).getWeight()) >= 0) continue;
            return spell;
        }
        return list.getLast();
    }

    public static Holder<Spell> getSpellInUse(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isUsingItem()) {
            return SpellHelper.getSpell(livingEntity.getUseItem());
        }
        return Spells.NONE;
    }
}

