/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.container.ECContainerHelper;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.spell.properties.SpellProperties;
import sirttas.elementalcraft.spell.tick.AbstractSpellInstance;
import sirttas.elementalcraft.spell.tick.ISpellTickManager;
import sirttas.elementalcraft.spell.tick.SpellTickHelper;

public class Spell
implements IElementTypeProvider {
    private String descriptionId;
    protected final Holder<SpellProperties> properties;
    private final ResourceKey<Spell> key;

    protected Spell(ResourceKey<Spell> key) {
        this.properties = ElementalCraft.SPELL_PROPERTIES_MANAGER.getOrCreateHolder(SpellProperties.getKey(key));
        this.key = key;
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId((String)"elementalcraft_spell", (ResourceLocation)this.getKey());
        }
        return this.descriptionId;
    }

    public ResourceLocation getKey() {
        return this.key.location();
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getDescriptionId());
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getOnUseAttributeModifiers() {
        return this.getProperties().getAttributes();
    }

    @Nonnull
    public InteractionResult castOnEntity(@Nonnull Entity caster, @Nonnull Entity target) {
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResult castOnBlock(@Nonnull Entity caster, @Nonnull BlockPos target, @Nonnull BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        return InteractionResult.PASS;
    }

    public void addSpellInstance(AbstractSpellInstance instance) {
        ISpellTickManager manager = SpellTickHelper.get(instance.getCaster());
        if (manager != null) {
            manager.addSpellInstance(instance);
        }
    }

    public void delay(Entity caster, int delay, Runnable cast) {
        this.addSpellInstance(AbstractSpellInstance.delay(caster, this, delay, cast));
    }

    public void effect(Entity caster, int duration, Consumer<AbstractSpellInstance> tick) {
        this.addSpellInstance(AbstractSpellInstance.effect(caster, this, duration, tick));
    }

    public boolean consume(Entity caster, boolean simulate) {
        block5: {
            block4: {
                if (!(caster instanceof Player)) break block4;
                Player player = (Player)caster;
                if (player.getAbilities().instabuild) break block5;
            }
            int consumeAmount = Math.max(1, Math.round((float)this.getConsumeAmount() * ToolInfusionHelper.getElementCostReduction(caster)));
            IElementStorage storage = (IElementStorage)caster.getCapability(ElementalCraftCapabilities.ElementStorage.ENTITY);
            if (storage == null) {
                return false;
            }
            return storage.extractElement(consumeAmount, this.getElementType(), simulate) >= consumeAmount;
        }
        return true;
    }

    protected boolean consume(Entity caster, ItemLike item, int count, boolean simulate) {
        if (caster instanceof Player) {
            Player player = (Player)caster;
            if (!player.getAbilities().instabuild) {
                Inventory inv = player.getInventory();
                int slot = ECContainerHelper.getSlotFor((Container)inv, new ItemStack(item));
                if (slot >= 0) {
                    ItemStack stack = inv.getItem(slot);
                    int size = Math.min(count, stack.getCount());
                    if (!simulate) {
                        stack.shrink(size);
                        if (stack.isEmpty()) {
                            inv.setItem(slot, ItemStack.EMPTY);
                        }
                    }
                    if (size < count) {
                        return this.consume(caster, item, count - size, simulate);
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public int getCooldown() {
        return this.getProperties().cooldown();
    }

    public int getConsumeAmount() {
        return this.getProperties().consumeAmount();
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.getProperties().getElementType();
    }

    public Type getSpellType() {
        return this.getProperties().spellType();
    }

    public int getUseDuration() {
        return this.getProperties().useDuration();
    }

    public int getWeight() {
        return this.getProperties().weight();
    }

    public float getStrength() {
        return this.getProperties().strength();
    }

    public float getRange(@Nullable Entity caster) {
        LivingEntity livingEntity;
        int bonus = 0;
        if (caster instanceof LivingEntity && EntityHelper.handStream(livingEntity = (LivingEntity)caster).anyMatch(s -> !s.isEmpty() && s.is((Item)ECItems.STAFF.get()))) {
            ++bonus;
        }
        return this.getProperties().range() + (float)bonus;
    }

    public int getColor() {
        return this.getProperties().color();
    }

    private SpellProperties getProperties() {
        if (this.properties.isBound()) {
            return (SpellProperties)this.properties.value();
        }
        return SpellProperties.NONE;
    }

    public boolean isChannelable() {
        return this.getUseDuration() > 0;
    }

    public boolean isValid() {
        return this.getSpellType() != Type.NONE && this.getElementType() != ElementType.NONE;
    }

    public void addInformation(List<Component> tooltip) {
    }

    public String toString() {
        return this.key.toString();
    }

    public boolean isVisible() {
        return this.isValid() && !this.getProperties().hidden();
    }

    public UseAnim getUseAnimation() {
        return UseAnim.BOW;
    }

    public static enum Type implements StringRepresentable
    {
        NONE("none"),
        COMBAT("combat"),
        UTILITY("utility"),
        MIXED("mixed");

        public static final Codec<Type> CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @Nonnull
        public String getSerializedName() {
            return this.name;
        }

        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return NONE;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }
}

