/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import sirttas.elementalcraft.item.TooltipHelper;
import sirttas.elementalcraft.spell.Spell;

public class EffectSpell
extends Spell {
    private final List<MobEffectInstance> effects;

    public EffectSpell(ResourceKey<Spell> key, MobEffectInstance ... effects) {
        super(key);
        this.effects = ImmutableList.copyOf((Object[])effects);
    }

    private InteractionResult applyEffect(Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            this.effects.forEach(e -> livingEntity.addEffect(new MobEffectInstance(e)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nonnull
    public InteractionResult castOnEntity(@Nonnull Entity caster, @Nonnull Entity target) {
        return this.applyEffect(target);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        return this.applyEffect(caster);
    }

    @Override
    public void addInformation(List<Component> tooltip) {
        HashMultimap multiMap = HashMultimap.create();
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance effectInstance : this.effects) {
                MutableComponent mutableComponent = Component.translatable((String)effectInstance.getDescriptionId());
                MobEffect effect = (MobEffect)effectInstance.getEffect().value();
                int amplifier = effectInstance.getAmplifier();
                effect.createModifiers(effectInstance.getAmplifier(), (arg_0, arg_1) -> ((Multimap)multiMap).put(arg_0, arg_1));
                if (amplifier > 0) {
                    mutableComponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, Component.translatable((String)("potion.potency." + amplifier))});
                }
                if (effectInstance.getDuration() > 20) {
                    mutableComponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)20.0f)});
                }
                tooltip.add((Component)mutableComponent.withStyle(effect.getCategory().getTooltipFormatting()));
            }
        }
        TooltipHelper.addAttributeMultiMapToTooltip(tooltip, (Multimap<Holder<Attribute>, AttributeModifier>)multiMap, (Component)Component.translatable((String)"tooltip.elementalcraft.spell_effect_on_use").withStyle(ChatFormatting.DARK_PURPLE));
    }

    public final List<MobEffectInstance> getEffects() {
        return this.effects;
    }
}

