/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import sirttas.elementalcraft.spell.Spell;

public class AoeSpell
extends Spell {
    protected AoeSpell(ResourceKey<Spell> key) {
        super(key);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        Level level = caster.level();
        float range = this.getRange(caster);
        if (caster instanceof LivingEntity) {
            LivingEntity livingSender = (LivingEntity)caster;
            AttributeInstance attribute = livingSender.getAttribute(Attributes.ATTACK_DAMAGE);
            float damageBase = attribute != null ? (float)attribute.getValue() : 1.0f;
            float damageMultiplier = (1.0f + (float)livingSender.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO)) * this.getStrength();
            for (LivingEntity target : level.getEntitiesOfClass(LivingEntity.class, livingSender.getBoundingBox().inflate((double)(range + 1.0f), 0.25, (double)(range + 1.0f)))) {
                this.hitTarget(level, livingSender, target, damageBase * damageMultiplier);
            }
            level.playSound(null, livingSender.getX(), livingSender.getY(), livingSender.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, livingSender.getSoundSource(), 1.0f, 1.0f);
            livingSender.swing(InteractionHand.MAIN_HAND);
            if (livingSender instanceof Player) {
                Player playerSender = (Player)livingSender;
                playerSender.sweepAttack();
                playerSender.resetAttackStrengthTicker();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void hitTarget(Level level, LivingEntity sender, LivingEntity target, float damage) {
        ArmorStand stand;
        float range = this.getRange((Entity)sender);
        if (!(target == sender || sender.isAlliedTo((Entity)target) || target instanceof ArmorStand && (stand = (ArmorStand)target).isMarker() || !(sender.distanceToSqr((Entity)target) < (double)(range * range)))) {
            DamageSource damageSource;
            DamageSources sources = level.damageSources();
            if (sender instanceof Player) {
                Player player = (Player)sender;
                damageSource = sources.playerAttack(player);
            } else {
                damageSource = sources.mobAttack(sender);
            }
            DamageSource damageSource2 = damageSource;
            damage = this.getEnchantedDamage(sender, (Entity)target, damage, damageSource2);
            if (damage > 0.0f) {
                target.knockback((double)0.4f, sender.getX() - target.getX(), sender.getZ() - target.getZ());
                target.hurt(damageSource2, damage);
                this.onHit(sender, target, damage);
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)target, (DamageSource)damageSource2);
                }
                this.hitWithItem(sender, target);
            }
        }
    }

    private float getEnchantedDamage(LivingEntity sender, Entity target, float damage, DamageSource damageSource) {
        Level level = sender.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)sender.getWeaponItem(), (Entity)target, (DamageSource)damageSource, (float)damage);
        }
        return damage;
    }

    protected void onHit(LivingEntity sender, LivingEntity target, float damage) {
    }

    private void hitWithItem(LivingEntity sender, LivingEntity target) {
        ItemStack stack = sender.getMainHandItem();
        if (!stack.isEmpty() && sender instanceof Player) {
            Player player = (Player)sender;
            ItemStack copy = stack.copy();
            stack.getItem().hurtEnemy(stack, target, (LivingEntity)player);
            if (stack.isEmpty()) {
                EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)InteractionHand.MAIN_HAND);
                sender.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            }
        }
    }
}

