/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelDataManager;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.renderer.ECRenderTypes;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.capability.PipeUpgradeCapabilities;
import sirttas.elementalcraft.event.TickHandler;

public class ECRendererHelper {
    public static final float SPACING = 0.001f;

    private ECRendererHelper() {
    }

    public static Material getBlockMaterial(String name) {
        return ECRendererHelper.getBlockMaterial(ElementalCraftApi.createRL(name));
    }

    public static Material getBlockMaterial(ResourceLocation loc) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, loc);
    }

    public static void renderIcon(PoseStack poseStack, MultiBufferSource buffer, Material renderMaterial, int width, int height) {
        ECRendererHelper.renderIcon(poseStack, renderMaterial.buffer(buffer, RenderType::entityTranslucent), 0.0f, 0.0f, width, height, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY);
    }

    public static void renderIcon(PoseStack poseStack, MultiBufferSource buffer, Material renderMaterial, int width, int height, int light, int overlay) {
        ECRendererHelper.renderIcon(poseStack, renderMaterial.buffer(buffer, RenderType::entityTranslucent), 0.0f, 0.0f, width, height, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    public static void renderIcon(PoseStack poseStack, VertexConsumer builder, int width, int height, int light, int overlay) {
        ECRendererHelper.renderIcon(poseStack, builder, 0.0f, 0.0f, width, height, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    public static void renderIcon(PoseStack poseStack, MultiBufferSource buffer, float x, float y, Material renderMaterial, int width, int height, float r, float g, float b, int light, int overlay) {
        ECRendererHelper.renderIcon(poseStack, renderMaterial.buffer(buffer, RenderType::entityTranslucent), x, y, width, height, r, g, b, light, overlay);
    }

    public static void renderIcon(PoseStack poseStack, VertexConsumer builder, float x, float y, int width, int height, float r, float g, float b, int light, int overlay) {
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix = pose.pose();
        builder.addVertex(matrix, x, y, 0.0f).setColor(r, g, b, 1.0f).setUv(0.0f, 0.0f).setOverlay(overlay).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix, x + (float)width, y, 0.0f).setColor(r, g, b, 1.0f).setUv(1.0f, 0.0f).setOverlay(overlay).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix, x + (float)width, y + (float)height, 0.0f).setColor(r, g, b, 1.0f).setUv(1.0f, 1.0f).setOverlay(overlay).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix, x, y + (float)height, 0.0f).setColor(r, g, b, 1.0f).setUv(0.0f, 1.0f).setOverlay(overlay).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public static Quaternionf getRotation(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> Axis.YP.rotationDegrees(180.0f);
            case Direction.WEST -> Axis.YP.rotationDegrees(90.0f);
            case Direction.EAST -> Axis.YP.rotationDegrees(-90.0f);
            default -> new Quaternionf();
        };
    }

    public static void renderItem(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, poseStack, buffer, null, 0);
    }

    public static void renderBlock(BlockState state, PoseStack poseStack, MultiBufferSource buffer) {
        ECRendererHelper.renderBlock(state, poseStack, buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY);
    }

    public static void renderBlock(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, ModelData data) {
        if (state.isAir()) {
            return;
        }
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, poseStack, buffer, light, overlay, data, null);
    }

    public static void renderGhost(BlockState state, PoseStack poseStack, MultiBufferSource buffer, Level level, BlockPos pos) {
        ECRendererHelper.renderBatched(state, poseStack, buffer.getBuffer(ECRenderTypes.GHOST), level, pos);
    }

    public static void renderBatched(BlockState state, PoseStack poseStack, VertexConsumer consumer, Level level, BlockPos pos) {
        poseStack.pushPose();
        Minecraft.getInstance().getBlockRenderer().renderBatched(state, pos, (BlockAndTintGetter)level, poseStack, consumer, false, RandomSource.create(), ECRendererHelper.getModelData(level, pos), null);
        poseStack.popPose();
    }

    public static void renderBatched(BlockState state, PoseStack poseStack, MultiBufferSource buffer, Level level, BlockPos pos) {
        ECRendererHelper.renderBatched(state, poseStack, buffer, level, pos, ECRendererHelper.getModelData(level, pos));
    }

    public static void renderBatched(BlockState state, PoseStack poseStack, MultiBufferSource buffer, Level level, BlockPos pos, ModelData data) {
        poseStack.pushPose();
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        RandomSource rand = RandomSource.create();
        if (state.getRenderShape() != RenderShape.INVISIBLE) {
            BakedModel model = blockRenderer.getBlockModel(state);
            for (RenderType renderType : model.getRenderTypes(state, rand, data)) {
                VertexConsumer consumer = buffer.getBuffer(renderType);
                blockRenderer.renderBatched(state, pos, (BlockAndTintGetter)level, poseStack, consumer, false, rand, data, renderType);
            }
        }
        poseStack.popPose();
    }

    public static void renderFluid(BlockState state, PoseStack poseStack, MultiBufferSource buffer) {
        FluidState fluidState = state.getFluidState();
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((FluidState)fluidState);
        ResourceLocation overlayTexture = props.getOverlayTexture();
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[]{(TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(props.getStillTexture()), (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(props.getFlowingTexture()), overlayTexture == null ? null : (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(overlayTexture)};
        VertexConsumer consumer = buffer.getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState));
        int tintColor = props.getTintColor();
        float alpha = (float)(tintColor >> 24 & 0xFF) / 255.0f;
        float r = (float)(tintColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(tintColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(tintColor & 0xFF) / 255.0f;
        TextureAtlasSprite sprite1 = sprites[0];
        float f18 = sprite1.getU(0.0f);
        float f22 = sprite1.getV(0.0f);
        float f19 = f18;
        float f23 = sprite1.getV(16.0f);
        float f20 = sprite1.getU(16.0f);
        float f24 = f23;
        float f21 = f20;
        float f25 = f22;
        float f49 = (f18 + f19 + f20 + f21) / 4.0f;
        float f50 = (f22 + f23 + f24 + f25) / 4.0f;
        float f51 = sprite1.uvShrinkRatio();
        f18 = Mth.lerp((float)f51, (float)f18, (float)f49);
        f19 = Mth.lerp((float)f51, (float)f19, (float)f49);
        f20 = Mth.lerp((float)f51, (float)f20, (float)f49);
        f21 = Mth.lerp((float)f51, (float)f21, (float)f49);
        f22 = Mth.lerp((float)f51, (float)f22, (float)f50);
        f23 = Mth.lerp((float)f51, (float)f23, (float)f50);
        f24 = Mth.lerp((float)f51, (float)f24, (float)f50);
        f25 = Mth.lerp((float)f51, (float)f25, (float)f50);
        ECRendererHelper.fluidVertex(poseStack, consumer, 0.0f, 0.999f, 0.0f, r, g, b, alpha, f18, f22);
        ECRendererHelper.fluidVertex(poseStack, consumer, 0.0f, 0.999f, 1.0f, r, g, b, alpha, f19, f23);
        ECRendererHelper.fluidVertex(poseStack, consumer, 1.0f, 0.999f, 1.0f, r, g, b, alpha, f20, f24);
        ECRendererHelper.fluidVertex(poseStack, consumer, 1.0f, 0.999f, 0.0f, r, g, b, alpha, f21, f25);
        float f40 = sprite1.getU0();
        float f41 = sprite1.getU1();
        float f42 = sprite1.getV0();
        float f43 = sprite1.getV1();
        ECRendererHelper.fluidVertex(poseStack, consumer, 0.0f, 0.001f, 1.0f, r, g, b, alpha, f40, f43);
        ECRendererHelper.fluidVertex(poseStack, consumer, 0.0f, 0.001f, 0.0f, r, g, b, alpha, f40, f42);
        ECRendererHelper.fluidVertex(poseStack, consumer, 1.0f, 0.001f, 0.0f, r, g, b, alpha, f41, f42);
        ECRendererHelper.fluidVertex(poseStack, consumer, 1.0f, 0.001f, 1.0f, r, g, b, alpha, f41, f43);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            float d4;
            float d5;
            float d3;
            float f45;
            float f44;
            float d6 = switch (direction) {
                case Direction.NORTH -> {
                    f44 = 0.999f;
                    f45 = 0.999f;
                    d3 = 0.0f;
                    d5 = 1.0f;
                    d4 = 0.001f;
                    yield 0.001f;
                }
                case Direction.SOUTH -> {
                    f44 = 0.999f;
                    f45 = 0.999f;
                    d3 = 1.0f;
                    d5 = 0.0f;
                    d4 = 0.999f;
                    yield 0.999f;
                }
                case Direction.WEST -> {
                    f44 = 0.999f;
                    f45 = 0.999f;
                    d3 = 0.001f;
                    d5 = 0.001f;
                    d4 = 1.0f;
                    yield 0.0f;
                }
                default -> {
                    f44 = 0.999f;
                    f45 = 0.999f;
                    d3 = 0.999f;
                    d5 = 0.999f;
                    d4 = 0.0f;
                    yield 1.0f;
                }
            };
            TextureAtlasSprite sprite2 = sprites[2] != null ? sprites[2] : sprites[1];
            float f54 = sprite2.getU(0.0f);
            float f55 = sprite2.getU(8.0f);
            float f33 = sprite2.getV((1.0f - f44) * 16.0f * 0.5f);
            float f34 = sprite2.getV((1.0f - f45) * 16.0f * 0.5f);
            float f35 = sprite2.getV(8.0f);
            ECRendererHelper.fluidVertex(poseStack, consumer, d3, f44, d4, r, g, b, alpha, f54, f33);
            ECRendererHelper.fluidVertex(poseStack, consumer, d5, f45, d6, r, g, b, alpha, f55, f34);
            ECRendererHelper.fluidVertex(poseStack, consumer, d5, 0.001f, d6, r, g, b, alpha, f55, f35);
            ECRendererHelper.fluidVertex(poseStack, consumer, d3, 0.001f, d4, r, g, b, alpha, f54, f35);
            if (sprite2 == ModelBakery.WATER_OVERLAY.sprite()) continue;
            ECRendererHelper.fluidVertex(poseStack, consumer, d3, 0.001f, d4, r, g, b, alpha, f54, f35);
            ECRendererHelper.fluidVertex(poseStack, consumer, d5, 0.001f, d6, r, g, b, alpha, f55, f35);
            ECRendererHelper.fluidVertex(poseStack, consumer, d5, f45, d6, r, g, b, alpha, f55, f34);
            ECRendererHelper.fluidVertex(poseStack, consumer, d3, f44, d4, r, g, b, alpha, f54, f33);
        }
    }

    private static void fluidVertex(PoseStack poseStack, VertexConsumer consumer, float x, float y, float z, float r, float g, float b, float alpha, float u, float v) {
        PoseStack.Pose last = poseStack.last();
        consumer.addVertex(last.pose(), x, y, z).setColor(r, g, b, alpha).setUv(u, v).setLight(0xF000F0).setNormal(last, 0.0f, 1.0f, 0.0f);
    }

    public static void renderRunes(PoseStack poseStack, MultiBufferSource buffer, PipeUpgrade pu, float tick, int light, int overlay) {
        IRuneHandler handler = pu.getCapability(PipeUpgradeCapabilities.RUNE_HANDLER, null);
        if (handler != null && !handler.isEmpty()) {
            ECRendererHelper.renderRunes(poseStack, buffer, handler, ECRendererHelper.getClientTicks(tick), light, overlay);
        }
    }

    public static void renderRunes(PoseStack poseStack, MultiBufferSource buffer, BlockEntity be, float tick, int light, int overlay) {
        IRuneHandler handler = BlockEntityHelper.getCapability(ElementalCraftCapabilities.RuneHandler.BLOCK, be, null);
        if (handler != null && !handler.isEmpty()) {
            ECRendererHelper.renderRunes(poseStack, buffer, handler, ECRendererHelper.getClientTicks(tick), light, overlay);
        }
    }

    public static void renderRunes(PoseStack poseStack, MultiBufferSource buffer, IRuneHandler handler, float tick, int light, int overlay) {
        int runeCount = handler.getRuneCount();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.75f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(tick / 2.0f));
        handler.getRunes().forEach(rune -> {
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f / (float)runeCount));
            poseStack.pushPose();
            poseStack.translate(0.75f, 0.0f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            poseStack.scale(0.015625f, 0.015625f, 0.015625f);
            ECRendererHelper.renderIcon(poseStack, buffer, rune.getSprite(), 16, -16, light, overlay);
            poseStack.popPose();
        });
        poseStack.popPose();
    }

    @Deprecated
    public static void renderModel(BakedModel model, PoseStack matrixStack, MultiBufferSource buffer, BlockState state, int light, int overlay) {
        ECRendererHelper.renderModel(model, matrixStack, buffer, state, light, overlay, ModelData.EMPTY);
    }

    public static void renderModel(BakedModel model, PoseStack matrixStack, MultiBufferSource buffer, BlockState state, int light, int overlay, ModelData data) {
        RenderType renderType = state != null ? ItemBlockRenderTypes.getRenderType((BlockState)state, (boolean)false) : Sheets.cutoutBlockSheet();
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(matrixStack.last(), buffer.getBuffer(renderType), state, model, 1.0f, 1.0f, 1.0f, light, overlay, data, renderType);
    }

    public static float getClientTicks(float partialTicks) {
        return (float)TickHandler.getTicksInGame() + partialTicks;
    }

    public static ModelData getModelData(Level level, BlockPos pos) {
        ModelDataManager modelDataManager = level.getModelDataManager();
        if (modelDataManager == null) {
            return ModelData.EMPTY;
        }
        ModelData data = modelDataManager.getAt(pos);
        if (data == null) {
            return ModelData.EMPTY;
        }
        return data;
    }

    public static void renderModel(BakedModel model, PoseStack matrixStack, MultiBufferSource buffer, BlockEntity te, int light, int overlay) {
        ECRendererHelper.renderModel(model, matrixStack, buffer, te.getBlockState(), light, overlay, ECRendererHelper.getModelData(model, te));
    }

    public static ModelData getModelData(BakedModel model, BlockEntity te) {
        Level level = te.getLevel();
        BlockPos pos = te.getBlockPos();
        if (level == null) {
            return ModelData.EMPTY;
        }
        return model.getModelData((BlockAndTintGetter)level, pos, te.getBlockState(), ECRendererHelper.getModelData(level, pos));
    }
}

