/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.pure.infusion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.IECRecipe;
import sirttas.elementalcraft.recipe.pure.infusion.PureInfusionRecipeInput;

public class PureInfusionRecipe
implements IECRecipe<PureInfusionRecipeInput> {
    public static final String NAME = "pureinfusion";
    private static final Codec<Map<ElementType, Ingredient>> INGREDIENTS_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC.fieldOf("pure_infuser").forGetter(i -> (Ingredient)i.get(ElementType.NONE)), (App)Ingredient.CODEC.fieldOf(ElementType.FIRE.getSerializedName()).forGetter(i -> (Ingredient)i.get(ElementType.FIRE)), (App)Ingredient.CODEC.fieldOf(ElementType.WATER.getSerializedName()).forGetter(i -> (Ingredient)i.get(ElementType.WATER)), (App)Ingredient.CODEC.fieldOf(ElementType.EARTH.getSerializedName()).forGetter(i -> (Ingredient)i.get(ElementType.EARTH)), (App)Ingredient.CODEC.fieldOf(ElementType.AIR.getSerializedName()).forGetter(i -> (Ingredient)i.get(ElementType.AIR))).apply((Applicative)builder, (i, f, w, e, a) -> Map.of(ElementType.NONE, i, ElementType.FIRE, f, ElementType.WATER, w, ElementType.EARTH, e, ElementType.AIR, a)));
    public static final MapCodec<PureInfusionRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("element_amount").forGetter(PureInfusionRecipe::getElementAmount), (App)INGREDIENTS_CODEC.fieldOf("ingredients").forGetter(r -> r.ingredients), (App)ItemStack.CODEC.fieldOf("output").forGetter(r -> r.output)).apply((Applicative)builder, PureInfusionRecipe::new));
    private final Map<ElementType, Ingredient> ingredients;
    private final ItemStack output;
    private final int elementAmount;

    public PureInfusionRecipe(int elementAmount, Map<ElementType, Ingredient> ingredients, ItemStack output) {
        this.ingredients = ingredients;
        this.output = output;
        this.elementAmount = elementAmount;
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        return this.output;
    }

    public boolean matches(@Nonnull PureInfusionRecipeInput input, @Nonnull Level level) {
        return this.ingredients.get(ElementType.NONE).test(input.pureInfuserInput()) && this.ingredients.get(ElementType.FIRE).test(input.getStackInPedestal(ElementType.FIRE)) && this.ingredients.get(ElementType.WATER).test(input.getStackInPedestal(ElementType.WATER)) && this.ingredients.get(ElementType.EARTH).test(input.getStackInPedestal(ElementType.EARTH)) && this.ingredients.get(ElementType.AIR).test(input.getStackInPedestal(ElementType.AIR));
    }

    @Nonnull
    public Map<ElementType, Ingredient> getIngredientsMap() {
        return this.ingredients;
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.copyOf(this.ingredients.values());
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ECRecipeSerializers.PURE_INFUSION.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ECRecipeTypes.PURE_INFUSION.get();
    }

    @Override
    @NotNull
    public ItemStack assemble(@Nonnull PureInfusionRecipeInput input, @Nonnull HolderLookup.Provider provider) {
        ItemStack result = this.getResultItem(provider).copy();
        IElementStorage target = (IElementStorage)result.getCapability(ElementalCraftCapabilities.ElementStorage.ITEM);
        if (target == null) {
            return result;
        }
        for (ItemStack stack : input.getStacksInPedestals()) {
            IElementStorage storage = (IElementStorage)stack.getCapability(ElementalCraftCapabilities.ElementStorage.ITEM);
            if (storage == null) continue;
            storage.transferAll(target);
        }
        return result;
    }

    public int getElementAmount() {
        return this.elementAmount;
    }
}

