/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.melting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.IECRecipe;
import sirttas.elementalcraft.recipe.melting.MeltingRecipeInput;

public record MeltingRecipe(HolderSet<Block> input, Fluid result, int cooldown, int elementAmount, float fillingAmount) implements IECRecipe<MeltingRecipeInput>
{
    public static final String NAME = "melting";

    public boolean matches(@NotNull MeltingRecipeInput recipeInput, @NotNull Level level) {
        return recipeInput.elementAmount() >= this.elementAmount * recipeInput.elementConsumption() && recipeInput.state().is(this.input);
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ECRecipeSerializers.MELTING.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ECRecipeTypes.MELTING.get();
    }

    public static class Serializer
    implements RecipeSerializer<MeltingRecipe> {
        public static final MapCodec<MeltingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("input").forGetter(MeltingRecipe::input), (App)BuiltInRegistries.FLUID.byNameCodec().optionalFieldOf("result", (Object)Fluids.EMPTY).forGetter(MeltingRecipe::result), (App)Codec.INT.fieldOf("cooldown").forGetter(MeltingRecipe::cooldown), (App)Codec.INT.fieldOf("element_amount").forGetter(MeltingRecipe::elementAmount), (App)Codec.FLOAT.optionalFieldOf("filling_amount", (Object)Float.valueOf(1000.0f)).forGetter(MeltingRecipe::fillingAmount)).apply((Applicative)builder, MeltingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MeltingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.BLOCK), MeltingRecipe::input, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.FLUID), MeltingRecipe::result, (StreamCodec)ByteBufCodecs.INT, MeltingRecipe::cooldown, (StreamCodec)ByteBufCodecs.INT, MeltingRecipe::elementAmount, (StreamCodec)ByteBufCodecs.FLOAT, MeltingRecipe::fillingAmount, MeltingRecipe::new);

        @NotNull
        public MapCodec<MeltingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, MeltingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

