/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.io.sawing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.instrument.io.IOInstrumentRecipe;
import sirttas.elementalcraft.recipe.instrument.io.SimpleIOInstrumentRecipeInput;

public record SawingRecipe(int elementAmount, double luckRatio, Ingredient ingredient, ItemStack output) implements IOInstrumentRecipe<SimpleIOInstrumentRecipeInput>
{
    public static final String NAME = "sawing";

    public SawingRecipe {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Sawing recipe output must not be empty");
        }
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public boolean matches(@NotNull ItemStack stack, @Nonnull Level level) {
        return this.ingredient.test(stack) && IOInstrumentRecipe.super.matches(stack, level);
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.ingredient});
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        return this.output;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ECRecipeSerializers.SAWING.get();
    }

    @Override
    public int getLuck(SimpleIOInstrumentRecipeInput input) {
        return (int)Math.round((double)input.getRuneBonus(Rune.BonusType.LUCK) * this.luckRatio);
    }

    @Override
    public List<ElementType> getValidElementTypes() {
        return List.of(ElementType.WATER, ElementType.AIR);
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ECRecipeTypes.SAWING.get();
    }

    public static class Serializer
    implements RecipeSerializer<SawingRecipe> {
        public static final MapCodec<SawingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("element_amount").forGetter(SawingRecipe::elementAmount), (App)Codec.DOUBLE.optionalFieldOf("luck_ratio", (Object)0.0).forGetter(SawingRecipe::luckRatio), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(SawingRecipe::ingredient), (App)ItemStack.CODEC.fieldOf("output").forGetter(SawingRecipe::output)).apply((Applicative)builder, SawingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SawingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Nonnull
        public MapCodec<SawingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SawingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SawingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int elementAmount = buffer.readInt();
            double luckRation = buffer.readDouble();
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new SawingRecipe(elementAmount, luckRation, ingredient, output);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, SawingRecipe recipe) {
            buffer.writeInt(recipe.getElementAmount());
            buffer.writeDouble(recipe.luckRatio());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }
}

