/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.io.purification;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.instrument.ISingleElementInstrumentRecipe;
import sirttas.elementalcraft.recipe.instrument.io.IOInstrumentRecipe;
import sirttas.elementalcraft.recipe.instrument.io.SimpleIOInstrumentRecipeInput;

public record OrePurificationRecipe(Ingredient input, ItemStack output, int elementAmount, int inputSize, double luckRatio) implements IOInstrumentRecipe<SimpleIOInstrumentRecipeInput>,
ISingleElementInstrumentRecipe<SimpleIOInstrumentRecipeInput>
{
    public static final String NAME = "ore_purification";

    @Override
    public boolean matches(@NotNull ItemStack stack, @Nonnull Level level) {
        return this.getIngredients().stream().allMatch(i -> i.test(stack)) && !this.getResultItem((HolderLookup.Provider)level.registryAccess()).isEmpty() && IOInstrumentRecipe.super.matches(stack, level);
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return ElementType.EARTH;
    }

    @Override
    public int getLuck(SimpleIOInstrumentRecipeInput input) {
        return (int)Math.round((double)input.getRuneBonus(Rune.BonusType.LUCK) * this.luckRatio);
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ECRecipeTypes.ORE_PURIFICATION.get();
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.input});
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ECRecipeSerializers.ORE_PURIFICATION.get();
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        return this.output;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public int getInputSize() {
        return this.inputSize;
    }

    public static class Serializer
    implements RecipeSerializer<OrePurificationRecipe> {
        public static final MapCodec<OrePurificationRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("input").forGetter(OrePurificationRecipe::input), (App)ItemStack.CODEC.fieldOf("output").forGetter(OrePurificationRecipe::output), (App)Codec.INT.fieldOf("element_amount").forGetter(OrePurificationRecipe::elementAmount), (App)Codec.INT.optionalFieldOf("input_size", (Object)1).forGetter(OrePurificationRecipe::inputSize), (App)Codec.DOUBLE.optionalFieldOf("luck_ratio", (Object)0.0).forGetter(OrePurificationRecipe::luckRatio)).apply((Applicative)builder, OrePurificationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, OrePurificationRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Nonnull
        public MapCodec<OrePurificationRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, OrePurificationRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static OrePurificationRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int elementAmount = buffer.readInt();
            int inputSize = buffer.readInt();
            double luckRatio = buffer.readDouble();
            return new OrePurificationRecipe(input, output, elementAmount, inputSize, luckRatio);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, OrePurificationRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input());
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            buffer.writeInt(recipe.elementAmount());
            buffer.writeInt(recipe.inputSize());
            buffer.writeDouble(recipe.luckRatio());
        }
    }
}

