/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.io;

import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.recipe.input.RuneBonusesRecipeInput;
import sirttas.elementalcraft.recipe.instrument.io.IOInstrumentRecipeInput;

public record SimpleIOInstrumentRecipeInput(ItemStack input, ItemStack output, int itemLimit, RandomSource randomSource, ElementType elementType, int elementAmount, Map<Rune.BonusType, Float> bonuses) implements IOInstrumentRecipeInput,
RuneBonusesRecipeInput
{
    public SimpleIOInstrumentRecipeInput(ItemStack input, ItemStack output, int itemLimit, RandomSource randomSource, ElementType elementType, int elementAmount, Map<Rune.BonusType, Float> bonuses) {
        this.input = input;
        this.output = output;
        this.itemLimit = itemLimit;
        this.randomSource = randomSource;
        this.elementType = elementType;
        this.elementAmount = elementAmount;
        this.bonuses = Map.copyOf(bonuses);
    }

    public SimpleIOInstrumentRecipeInput(ItemStack input, ItemStack output, RandomSource randomSource, ElementType elementType, int elementAmount, Map<Rune.BonusType, Float> bonuses) {
        this(input, output, 64, randomSource, elementType, elementAmount, bonuses);
    }

    @Override
    public int getElementAmount(@NotNull ElementType elementType) {
        return elementType == this.elementType ? this.elementAmount : 0;
    }

    @Override
    public RandomSource getRandomSource() {
        return this.randomSource;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return switch (slot) {
            case 0 -> this.input;
            case 1 -> this.output;
            default -> ItemStack.EMPTY;
        };
    }

    public int size() {
        return 2;
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public float getRuneBonus(Rune.BonusType type) {
        return this.bonuses.getOrDefault((Object)type, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public int getItemLimit(int slot) {
        return this.itemLimit;
    }
}

