/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.io;

import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.recipe.instrument.ISingleElementInstrumentRecipe;
import sirttas.elementalcraft.recipe.instrument.io.IOInstrumentRecipe;
import sirttas.elementalcraft.recipe.instrument.io.IOInstrumentRecipeInput;

public class FurnaceRecipeWrapper
implements IOInstrumentRecipe<IOInstrumentRecipeInput>,
ISingleElementInstrumentRecipe<IOInstrumentRecipeInput> {
    private final AbstractCookingRecipe recipe;

    public FurnaceRecipeWrapper(AbstractCookingRecipe recipe) {
        this.recipe = recipe;
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull IOInstrumentRecipeInput input, @Nonnull HolderLookup.Provider provider) {
        return this.recipe.assemble(new SingleRecipeInput(input.getItem(0)), provider);
    }

    @Override
    public boolean canCraftInDimensions(int width, int height) {
        return this.recipe.canCraftInDimensions(width, height);
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        return this.recipe.getResultItem(provider);
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return this.recipe.getSerializer();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return this.recipe.getType();
    }

    public float getExperience() {
        return this.recipe.getExperience();
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return ElementType.FIRE;
    }

    public int getDuration() {
        return this.recipe.getCookingTime();
    }

    @Override
    public int getElementAmount() {
        return this.getDuration() * (this.recipe.getType() == RecipeType.SMELTING ? (Integer)ECConfig.SERVER.fireFurnaceElementAmount.get() : (Integer)ECConfig.SERVER.fireBlastFurnaceElementAmount.get());
    }

    @Override
    public boolean matches(@NotNull IOInstrumentRecipeInput input, @Nonnull Level level) {
        return input.getElementType() == ElementType.FIRE && this.recipe.matches(new SingleRecipeInput(input.getItem(0)), level);
    }
}

