/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.infusion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.infusion.tool.ToolInfusion;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.input.SingleItemSingleElementRecipeInput;
import sirttas.elementalcraft.recipe.instrument.infusion.IInfusionRecipe;

public class ToolInfusionRecipe
implements IInfusionRecipe {
    public static final String NAME = "tool_infusion";
    private final Ingredient input;
    private final int elementAmount;
    private final Holder<ToolInfusion> toolInfusion;

    public ToolInfusionRecipe(Holder<ToolInfusion> toolInfusion, Ingredient input, int elementAmount) {
        this.toolInfusion = toolInfusion;
        this.input = input;
        this.elementAmount = elementAmount;
    }

    @Override
    public boolean matches(@NotNull SingleItemSingleElementRecipeInput input, @Nonnull Level level) {
        return IInfusionRecipe.super.matches(input, level) && !this.getToolInfusion().equals(ToolInfusionHelper.getInfusion(input.getItem(0)));
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull SingleItemSingleElementRecipeInput input, @Nonnull HolderLookup.Provider provider) {
        ItemStack stack = input.getItem(0).copy();
        ToolInfusionHelper.setInfusion(stack, this.toolInfusion);
        return stack;
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return ((ToolInfusion)this.getToolInfusion().value()).getElementType();
    }

    public Holder<ToolInfusion> getToolInfusion() {
        return this.toolInfusion;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ECRecipeSerializers.TOOL_INFUSION.get();
    }

    public static class Serializer
    implements RecipeSerializer<ToolInfusionRecipe> {
        public static final MapCodec<ToolInfusionRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ToolInfusion.HOLDER_CODEC.fieldOf(ToolInfusionRecipe.NAME).forGetter(r -> r.toolInfusion), (App)Ingredient.CODEC.fieldOf("input").forGetter(ToolInfusionRecipe::getInput), (App)Codec.INT.fieldOf("element_amount").forGetter(ToolInfusionRecipe::getElementAmount)).apply((Applicative)builder, ToolInfusionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ToolInfusionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Nonnull
        public MapCodec<ToolInfusionRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ToolInfusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ToolInfusionRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int elementAmount = buffer.readInt();
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Holder toolInfusion = ElementalCraftApi.TOOL_INFUSION_MANAGER.getOrCreateHolder(buffer.readResourceLocation());
            return new ToolInfusionRecipe((Holder<ToolInfusion>)toolInfusion, input, elementAmount);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, ToolInfusionRecipe recipe) {
            buffer.writeInt(recipe.getElementAmount());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            buffer.writeResourceLocation(ElementalCraftApi.TOOL_INFUSION_MANAGER.getId(recipe.getToolInfusion()));
        }
    }
}

