/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.infusion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.input.SingleItemSingleElementRecipeInput;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.IInfusionRecipe;

public class InfusionRecipe
extends AbstractInstrumentRecipe<SingleItemSingleElementRecipeInput>
implements IInfusionRecipe {
    private final Ingredient input;
    private final ItemStack output;
    private final int elementAmount;

    public InfusionRecipe(ElementType type, int elementAmount, Ingredient input, ItemStack output) {
        super(type);
        this.input = input;
        this.output = output;
        this.elementAmount = elementAmount;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        return this.output;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ECRecipeSerializers.INFUSION.get();
    }

    public static class Serializer
    implements RecipeSerializer<InfusionRecipe> {
        public static final MapCodec<InfusionRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group(ElementType.forGetter(AbstractInstrumentRecipe::getElementType), (App)Codec.INT.fieldOf("element_amount").forGetter(InfusionRecipe::getElementAmount), (App)Ingredient.CODEC.fieldOf("input").forGetter(InfusionRecipe::getInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(r -> r.output)).apply((Applicative)builder, InfusionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InfusionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Nonnull
        public MapCodec<InfusionRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, InfusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static InfusionRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ElementType type = ElementType.byName(buffer.readUtf());
            int elementAmount = buffer.readInt();
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new InfusionRecipe(type, elementAmount, input, output);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, InfusionRecipe recipe) {
            buffer.writeUtf(recipe.getElementType().getSerializedName());
            buffer.writeInt(recipe.getElementAmount());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }
}

