/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.enchantment.liquefaction;

import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.recipe.IRuntimeRecipe;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;
import sirttas.elementalcraft.recipe.instrument.ILuckRecipe;
import sirttas.elementalcraft.recipe.instrument.io.SimpleIOInstrumentRecipeInput;
import sirttas.elementalcraft.tag.ECTags;

public class EnchantmentLiquefactionRecipe
extends AbstractInstrumentRecipe<SimpleIOInstrumentRecipeInput>
implements ILuckRecipe<SimpleIOInstrumentRecipeInput>,
IRuntimeRecipe<SimpleIOInstrumentRecipeInput> {
    public static final String NAME = "enchantment_liquefaction";
    private final Holder<Enchantment> enchantment;

    public EnchantmentLiquefactionRecipe(Holder<Enchantment> enchantment) {
        super(ElementType.WATER);
        this.enchantment = enchantment;
    }

    public boolean matches(SimpleIOInstrumentRecipeInput recipeInput, @NotNull Level level) {
        if (recipeInput.getElementType() != ElementType.WATER) {
            return false;
        }
        ItemStack input = recipeInput.getItem(0);
        ItemStack output = recipeInput.getItem(1);
        if (input.isEmpty() || output.isEmpty()) {
            return false;
        }
        int inputLevel = this.getEnchantmentLevel(input);
        if (inputLevel <= 0 || !this.canEnchant(output)) {
            return false;
        }
        int outputLevel = this.getEnchantmentLevel(output);
        return inputLevel > outputLevel || inputLevel == outputLevel && inputLevel < ((Enchantment)this.enchantment.value()).getMaxLevel();
    }

    private boolean canEnchant(ItemStack stack) {
        return stack.isEnchantable() && stack.supportsEnchantment(this.enchantment) || stack.is(ECTags.Items.ENCHANTMENT_HOLDER);
    }

    public Holder<Enchantment> getEnchantment() {
        return this.enchantment;
    }

    @Override
    public int getElementAmount() {
        return ((Enchantment)this.getEnchantment().value()).getAnvilCost() * (Integer)ECConfig.SERVER.enchantmentLiquefierElementAmount.get();
    }

    @Override
    public int getElementAmount(SimpleIOInstrumentRecipeInput recipeInput) {
        return this.getElementAmount() * Math.max(1, this.getEnchantmentLevel(recipeInput.getItem(0)));
    }

    private int getBreakChance() {
        return (int)Math.round((double)((Enchantment)this.getEnchantment().value()).getAnvilCost() * (Double)ECConfig.SERVER.enchantmentLiquefierBreakChance.get());
    }

    @NotNull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @Override
    public int getLuck(SimpleIOInstrumentRecipeInput recipeInput) {
        return Math.round(recipeInput.getRuneBonus(Rune.BonusType.LUCK));
    }

    @Override
    @NotNull
    public ItemStack assemble(@Nonnull SimpleIOInstrumentRecipeInput recipeInput, @Nonnull HolderLookup.Provider provider) {
        ItemStack input = recipeInput.getItem(0);
        ItemStack output = recipeInput.getItem(1).copy();
        int inputLevel = this.getEnchantmentLevel(input);
        int outputLevel = this.getEnchantmentLevel(output);
        if (this.getRandomSource(recipeInput).nextInt(100) < this.getBreakChance() - this.getLuck(recipeInput)) {
            --inputLevel;
        }
        if (inputLevel <= 0) {
            return output;
        }
        if (output.is(Items.BOOK)) {
            output = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        }
        if (inputLevel > outputLevel) {
            this.setEnchantmentLevel(output, inputLevel);
        } else if (inputLevel == outputLevel && inputLevel < ((Enchantment)this.enchantment.value()).getMaxLevel()) {
            this.setEnchantmentLevel(output, inputLevel + 1);
        }
        return output;
    }

    private int getEnchantmentLevel(ItemStack stack) {
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        return enchantments.getLevel(this.enchantment);
    }

    private void setEnchantmentLevel(ItemStack stack, int level) {
        EnchantmentHelper.updateEnchantments((ItemStack)stack, e -> e.set(this.enchantment, level));
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(SimpleIOInstrumentRecipeInput recipeInput) {
        ItemStack input = recipeInput.getItem(0).copy();
        if (input.isEmpty()) {
            return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{ItemStack.EMPTY, ItemStack.EMPTY});
        }
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input);
        if (enchantments.isEmpty()) {
            return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{input, ItemStack.EMPTY});
        }
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(enchantments);
        mutable.removeIf(arg_0 -> this.enchantment.is(arg_0));
        enchantments = mutable.toImmutable();
        if (enchantments.isEmpty() && input.is(Items.ENCHANTED_BOOK)) {
            return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{new ItemStack((ItemLike)Items.BOOK), ItemStack.EMPTY});
        }
        return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{input, ItemStack.EMPTY});
    }
}

