/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.binding;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.input.MultipleItemsSingleElementRecipeInput;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;
import sirttas.elementalcraft.recipe.instrument.binding.AbstractBindingRecipe;

public class BindingRecipe
extends AbstractBindingRecipe {
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;
    private final int elementAmount;

    public BindingRecipe(ElementType type, int elementAmount, List<Ingredient> ingredients, ItemStack output) {
        super(type);
        this.ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
        this.output = output;
        this.elementAmount = elementAmount;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    public boolean matches(MultipleItemsSingleElementRecipeInput input, @Nonnull Level level) {
        if (input.getElementType() != this.getElementType() || input.size() != this.ingredients.size()) {
            return false;
        }
        return Boolean.TRUE.equals(ECConfig.SERVER.binderRecipeMatchOrder.get()) ? this.matchesOrdered(input) : RecipeHelper.matchesUnordered(input.stacks(), this.ingredients);
    }

    private boolean matchesOrdered(MultipleItemsSingleElementRecipeInput input) {
        int ingredientIndex = 0;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack s = input.getItem(i);
            if (s.isEmpty()) continue;
            if (ingredientIndex >= this.ingredients.size() || !((Ingredient)this.ingredients.get(ingredientIndex)).test(s)) {
                return false;
            }
            ++ingredientIndex;
        }
        return true;
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        return this.output;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ECRecipeSerializers.BINDING.get();
    }

    public static class Serializer
    implements RecipeSerializer<BindingRecipe> {
        public static final MapCodec<BindingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group(ElementType.forGetter(AbstractInstrumentRecipe::getElementType), (App)Codec.INT.fieldOf("element_amount").forGetter(BindingRecipe::getElementAmount), (App)Ingredient.LIST_CODEC.fieldOf("ingredients").forGetter(BindingRecipe::getIngredients), (App)ItemStack.CODEC.fieldOf("output").forGetter(r -> r.output)).apply((Applicative)builder, BindingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BindingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Nonnull
        public MapCodec<BindingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, BindingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static BindingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ElementType type = ElementType.byName(buffer.readUtf());
            int elementAmount = buffer.readInt();
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int i = buffer.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            ingredients.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            return new BindingRecipe(type, elementAmount, (List<Ingredient>)ingredients, output);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, BindingRecipe recipe) {
            buffer.writeUtf(recipe.getElementType().getSerializedName());
            buffer.writeInt(recipe.getElementAmount());
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            buffer.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ingredient : recipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
        }
    }
}

