/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.binding;

import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.recipe.input.MultipleItemsSingleElementRecipeInput;
import sirttas.elementalcraft.recipe.instrument.binding.AbstractBindingRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.IInfusionRecipe;

public class BinderInfusionRecipeWrapper
extends AbstractBindingRecipe {
    private final IInfusionRecipe recipe;

    public BinderInfusionRecipeWrapper(IInfusionRecipe infusionRecipe) {
        super(infusionRecipe.getElementType());
        this.recipe = infusionRecipe;
    }

    @Override
    public int getElementAmount() {
        return this.recipe.getElementAmount();
    }

    public boolean matches(MultipleItemsSingleElementRecipeInput input, @NotNull Level level) {
        return input.size() == 1 && this.recipe.matches(input.singleItem(), level);
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull MultipleItemsSingleElementRecipeInput input, @Nonnull HolderLookup.Provider provider) {
        if (input.size() == 1) {
            return this.recipe.assemble(input.singleItem(), provider);
        }
        return super.assemble(input, provider);
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        return this.recipe.getResultItem(provider);
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return this.recipe.getSerializer();
    }
}

