/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.input.MultipleItemsSingleElementRecipeInput;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;

public class InscriptionRecipe
extends AbstractInstrumentRecipe<MultipleItemsSingleElementRecipeInput> {
    public static final String NAME = "inscription";
    private final NonNullList<Ingredient> ingredients;
    private final int elementAmount;
    private final ItemStack output;

    public InscriptionRecipe(ElementType type, int elementAmount, List<Ingredient> ingredients, ItemStack output) {
        super(type);
        this.ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
        this.elementAmount = elementAmount;
        this.output = output;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    public boolean matches(@Nonnull MultipleItemsSingleElementRecipeInput input, @Nonnull Level level) {
        if (input.getElementType() == this.getElementType()) {
            return RecipeHelper.matchesUnordered(input.stacks(), this.ingredients);
        }
        return false;
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @Nonnull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.output;
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ECRecipeTypes.INSCRIPTION.get();
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ECRecipeSerializers.INSCRIPTION.get();
    }

    public static class Serializer
    implements RecipeSerializer<InscriptionRecipe> {
        public static final MapCodec<InscriptionRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group(ElementType.forGetter(AbstractInstrumentRecipe::getElementType), (App)Codec.INT.fieldOf("element_amount").forGetter(InscriptionRecipe::getElementAmount), (App)Ingredient.LIST_CODEC.fieldOf("ingredients").forGetter(InscriptionRecipe::getIngredients), (App)ItemStack.CODEC.fieldOf("output").forGetter(r -> r.output)).apply((Applicative)builder, InscriptionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InscriptionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<InscriptionRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, InscriptionRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static InscriptionRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ElementType type = ElementType.byName(buffer.readUtf());
            int elementAmount = buffer.readInt();
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int i = buffer.readInt();
            NonNullList ingredients = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < i; ++j) {
                ingredients.set(j, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
            }
            return new InscriptionRecipe(type, elementAmount, (List<Ingredient>)ingredients, output);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, InscriptionRecipe recipe) {
            buffer.writeUtf(recipe.getElementType().getSerializedName());
            buffer.writeInt(recipe.getElementAmount());
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            buffer.writeInt(recipe.getIngredients().size());
            recipe.getIngredients().forEach(ingredient -> Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, ingredient));
        }
    }
}

