/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.input.MultipleItemsSingleElementRecipeInput;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;

public class CrystallizationRecipe
extends AbstractInstrumentRecipe<MultipleItemsSingleElementRecipeInput> {
    public static final String NAME = "crystallization";
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack result;
    private final int elementAmount;

    public CrystallizationRecipe(ElementType type, int elementAmount, List<Ingredient> ingredients, ItemStack result) {
        super(type);
        this.ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
        this.result = result;
        this.elementAmount = elementAmount;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    public boolean matches(@Nonnull MultipleItemsSingleElementRecipeInput input, @Nonnull Level level) {
        if (input.getElementType() == this.getElementType() && input.size() >= 2) {
            for (int i = 0; i < 2; ++i) {
                if (((Ingredient)this.ingredients.get(i)).test(input.getItem(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        return this.result;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ECRecipeTypes.CRYSTALLIZATION.get();
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ECRecipeSerializers.CRYSTALLIZATION.get();
    }

    public static class Serializer
    implements RecipeSerializer<CrystallizationRecipe> {
        private static final Codec<List<Ingredient>> INGREDIENTS_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC.fieldOf("gem").forGetter(List::getFirst), (App)Ingredient.CODEC.fieldOf("crystal").forGetter(i -> (Ingredient)i.get(1))).apply((Applicative)builder, List::of));
        public static final MapCodec<CrystallizationRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group(ElementType.forGetter(AbstractInstrumentRecipe::getElementType), (App)Codec.INT.fieldOf("element_amount").forGetter(CrystallizationRecipe::getElementAmount), (App)INGREDIENTS_CODEC.fieldOf("ingredients").forGetter(CrystallizationRecipe::getIngredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result)).apply((Applicative)builder, CrystallizationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CrystallizationRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Nonnull
        public MapCodec<CrystallizationRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CrystallizationRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static CrystallizationRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ElementType type = ElementType.byName(buffer.readUtf());
            int elementAmount = buffer.readInt();
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int i = buffer.readInt();
            NonNullList ingredients = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < i; ++j) {
                ingredients.set(j, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
            }
            return new CrystallizationRecipe(type, elementAmount, (List<Ingredient>)ingredients, output);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, CrystallizationRecipe recipe) {
            buffer.writeUtf(recipe.getElementType().getSerializedName());
            buffer.writeInt(recipe.getElementAmount());
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeInt(recipe.getIngredients().size());
            recipe.getIngredients().forEach(ingredient -> Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, ingredient));
        }
    }
}

