/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.input;

import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.recipe.input.ElementRecipeInput;
import sirttas.elementalcraft.recipe.input.SingleItemSingleElementRecipeInput;

public record MultipleItemsSingleElementRecipeInput(List<ItemStack> stacks, ElementType elementType, int elementAmount) implements ElementRecipeInput
{
    public MultipleItemsSingleElementRecipeInput(List<ItemStack> stacks, ElementType elementType, int elementAmount) {
        this.stacks = stacks.stream().filter(s -> !s.isEmpty()).toList();
        this.elementType = elementType;
        this.elementAmount = elementAmount;
    }

    @Override
    public int getElementAmount(@NotNull ElementType elementType) {
        if (elementType != this.elementType) {
            return 0;
        }
        return this.elementAmount;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return this.stacks.get(slot);
    }

    public int size() {
        return this.stacks.size();
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public int getItemLimit(int slot) {
        return 1;
    }

    public SingleItemSingleElementRecipeInput singleItem() {
        if (this.size() != 1) {
            throw new IllegalStateException("Cannot convert to single item recipe input, it doesn't have exactly one item!");
        }
        return new SingleItemSingleElementRecipeInput(this.stacks.getFirst(), 1, this.elementType, this.elementAmount);
    }
}

