/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.cracking;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.recipe.IECRecipe;
import sirttas.elementalcraft.recipe.cracking.CrackingRecipeInput;

public abstract class AbstractCrackingRecipe
implements IECRecipe<CrackingRecipeInput> {
    private final HolderSet<Block> input;
    private final Block result;
    private final int elementAmount;

    protected AbstractCrackingRecipe(HolderSet<Block> input, Block result, int elementAmount) {
        this.input = input;
        this.result = result;
        this.elementAmount = elementAmount;
    }

    public boolean matches(@NotNull CrackingRecipeInput recipeInput, @NotNull Level level) {
        return recipeInput.state().is(this.input);
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public HolderSet<Block> input() {
        return this.input;
    }

    public Block result() {
        return this.result;
    }

    public int elementAmount() {
        return this.elementAmount;
    }

    public boolean hasResult() {
        return !this.result.defaultBlockState().isAir();
    }

    public static interface Factory<T extends AbstractCrackingRecipe> {
        public T create(HolderSet<Block> var1, Block var2, int var3);
    }
}

