/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.spell.FocusItem;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.IECRecipe;
import sirttas.elementalcraft.spell.SpellHelper;

public class StaffRecipe
extends ShapedRecipe
implements IECRecipe<CraftingInput> {
    public StaffRecipe(ShapedRecipe parent) {
        super(parent.getGroup(), parent.category(), parent.pattern, new ItemStack(ECItems.STAFF), parent.showNotification());
    }

    @Override
    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInput input, @Nonnull HolderLookup.Provider provider) {
        ItemStack staff = this.getResultItem(provider).copy();
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            Item item = stack.getItem();
            if (item instanceof FocusItem) {
                SpellHelper.copySpells(stack, staff);
                continue;
            }
            if (!(item instanceof SwordItem)) continue;
            EnchantmentHelper.setEnchantments((ItemStack)staff, (ItemEnchantments)EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack));
        }
        return staff;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ECRecipeSerializers.STAFF.get();
    }

    public static class Serializer
    implements RecipeSerializer<StaffRecipe> {
        public static final MapCodec<StaffRecipe> CODEC = RecipeSerializer.SHAPED_RECIPE.codec().xmap(StaffRecipe::new, Function.identity());
        public static final StreamCodec<RegistryFriendlyByteBuf, StaffRecipe> STREAM_CODEC = RecipeSerializer.SHAPED_RECIPE.streamCodec().map(StaffRecipe::new, Function.identity());

        @Nonnull
        public MapCodec<StaffRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, StaffRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

