/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.IECRecipe;

public class SpellCraftRecipe
implements IECRecipe<RecipeInput> {
    public static final String NAME = "spell_craft";
    private static final Ingredient SCROLL_PAPER = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ECItems.SCROLL_PAPER.get()});
    private final Ingredient gem;
    private final Ingredient crystal;
    private final ItemStack output;

    public SpellCraftRecipe(Ingredient gem, Ingredient crystal, ItemStack output) {
        this.output = output;
        this.gem = gem;
        this.crystal = crystal;
    }

    public boolean matches(RecipeInput inv, @Nonnull Level level) {
        return SCROLL_PAPER.test(inv.getItem(0)) && this.gem.test(inv.getItem(1)) && this.crystal.test(inv.getItem(2));
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        return this.output;
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{SCROLL_PAPER, this.gem, this.crystal});
    }

    @Nonnull
    public RecipeSerializer<SpellCraftRecipe> getSerializer() {
        return (RecipeSerializer)ECRecipeSerializers.SPELL_CRAFT.get();
    }

    @Nonnull
    public RecipeType<SpellCraftRecipe> getType() {
        return (RecipeType)ECRecipeTypes.SPELL_CRAFT.get();
    }

    public static class Serializer
    implements RecipeSerializer<SpellCraftRecipe> {
        public static final MapCodec<SpellCraftRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("gem").forGetter(r -> r.gem), (App)Ingredient.CODEC.fieldOf("crystal").forGetter(r -> r.crystal), (App)ItemStack.CODEC.fieldOf("output").forGetter(r -> r.output)).apply((Applicative)builder, SpellCraftRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SpellCraftRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Nonnull
        public MapCodec<SpellCraftRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SpellCraftRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static SpellCraftRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            Ingredient gem = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient crystal = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new SpellCraftRecipe(gem, crystal, output);
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, SpellCraftRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.gem);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.crystal);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }
}

