/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import sirttas.dpanvil.api.codec.recipe.CodecRecipeSerializer;
import sirttas.elementalcraft.recipe.SpellCraftRecipe;
import sirttas.elementalcraft.recipe.StaffRecipe;
import sirttas.elementalcraft.recipe.cracking.CrackingRecipe;
import sirttas.elementalcraft.recipe.cracking.CrackingRecipeSerializer;
import sirttas.elementalcraft.recipe.cracking.SculkCrackingRecipe;
import sirttas.elementalcraft.recipe.instrument.CrystallizationRecipe;
import sirttas.elementalcraft.recipe.instrument.InscriptionRecipe;
import sirttas.elementalcraft.recipe.instrument.binding.BindingRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.InfusionRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.ToolInfusionRecipe;
import sirttas.elementalcraft.recipe.instrument.io.grinding.GrindingRecipe;
import sirttas.elementalcraft.recipe.instrument.io.purification.OrePurificationRecipe;
import sirttas.elementalcraft.recipe.instrument.io.sawing.SawingRecipe;
import sirttas.elementalcraft.recipe.melting.MeltingRecipe;
import sirttas.elementalcraft.recipe.pure.infusion.PureInfusionRecipe;

public class ECRecipeSerializers {
    private static final DeferredRegister<RecipeSerializer<?>> DEFERRED_REGISTER = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"elementalcraft");
    public static final DeferredHolder<RecipeSerializer<?>, InfusionRecipe.Serializer> INFUSION = ECRecipeSerializers.register("infusion", InfusionRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, ToolInfusionRecipe.Serializer> TOOL_INFUSION = ECRecipeSerializers.register("tool_infusion", ToolInfusionRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, BindingRecipe.Serializer> BINDING = ECRecipeSerializers.register("binding", BindingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, CrystallizationRecipe.Serializer> CRYSTALLIZATION = ECRecipeSerializers.register("crystallization", CrystallizationRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, InscriptionRecipe.Serializer> INSCRIPTION = ECRecipeSerializers.register("inscription", InscriptionRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, OrePurificationRecipe.Serializer> ORE_PURIFICATION = ECRecipeSerializers.register("ore_purification", OrePurificationRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, GrindingRecipe.Serializer> GRINDING = ECRecipeSerializers.register("grinding", GrindingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, SawingRecipe.Serializer> SAWING = ECRecipeSerializers.register("sawing", SawingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, CodecRecipeSerializer<PureInfusionRecipe>> PURE_INFUSION = ECRecipeSerializers.register("pureinfusion", () -> new CodecRecipeSerializer(PureInfusionRecipe.CODEC));
    public static final DeferredHolder<RecipeSerializer<?>, SpellCraftRecipe.Serializer> SPELL_CRAFT = ECRecipeSerializers.register("spell_craft", SpellCraftRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, StaffRecipe.Serializer> STAFF = ECRecipeSerializers.register("staff", StaffRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, CrackingRecipeSerializer<CrackingRecipe>> CRACKING = ECRecipeSerializers.register("cracking", () -> new CrackingRecipeSerializer<CrackingRecipe>(CrackingRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, CrackingRecipeSerializer<SculkCrackingRecipe>> SCULK_CRACKING = ECRecipeSerializers.register("sculk_cracking", () -> new CrackingRecipeSerializer<SculkCrackingRecipe>(SculkCrackingRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, MeltingRecipe.Serializer> MELTING = ECRecipeSerializers.register("melting", MeltingRecipe.Serializer::new);

    private ECRecipeSerializers() {
    }

    private static <R extends Recipe<?>, T extends RecipeSerializer<R>> DeferredHolder<RecipeSerializer<?>, T> register(String name, Supplier<T> serializer) {
        return DEFERRED_REGISTER.register(name, serializer);
    }

    public static void register(IEventBus bus) {
        DEFERRED_REGISTER.register(bus);
    }
}

