/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.range;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;

public class RangeHelper {
    private RangeHelper() {
    }

    @Nonnull
    public static Stream<BlockPos> getBlocksInAABB(AABB box) {
        return RangeHelper.getRange(box.minX, box.maxX).mapToObj(x -> RangeHelper.getRange(box.minZ, box.maxZ).mapToObj(z -> RangeHelper.getRange(box.minY, box.maxY).mapToObj(y -> new BlockPos(x, y, z)))).mapMulti((s, downstream) -> s.forEach(s2 -> s2.forEach(downstream)));
    }

    @Nonnull
    private static IntStream getRange(double min, double max) {
        return IntStream.range((int)Math.floor(min + 1.0E-5), (int)Math.ceil(max - 1.0E-5));
    }
}

