/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore.loader;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.apache.logging.log4j.util.Supplier;
import sirttas.dpanvil.api.codec.Codecs;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.pureore.PureOreException;
import sirttas.elementalcraft.pureore.loader.AbstractPureOreLoader;
import sirttas.elementalcraft.pureore.loader.LoadedPureOre;
import sirttas.elementalcraft.pureore.loader.PureOreLoaderType;
import sirttas.elementalcraft.pureore.loader.PureOreLoaderTypes;

public class PatternPureOreLoader
extends AbstractPureOreLoader {
    public static final MapCodec<PatternPureOreLoader> CODEC = RecordCodecBuilder.mapCodec(builder -> {
        Products.P6 b1 = AbstractPureOreLoader.codec(builder);
        return new Products.P10(b1.t1(), b1.t2(), b1.t3(), b1.t4(), b1.t5(), b1.t6(), (App)Codecs.PATTERN.fieldOf("tag_pattern").forGetter(l -> l.tagPattern), (App)Codecs.PATTERN.listOf().optionalFieldOf("patterns", Collections.emptyList()).forGetter(l -> l.patterns), (App)Codec.STRING.optionalFieldOf("namespace", (Object)"c").forGetter(l -> l.namespace), (App)Codecs.PATTERN.optionalFieldOf("namespace_pattern").forGetter(l -> l.namespacePattern)).apply((Applicative)builder, PatternPureOreLoader::new);
    });
    final Pattern tagPattern;
    final List<Pattern> patterns;
    final String namespace;
    final Optional<Pattern> namespacePattern;

    public PatternPureOreLoader(HolderSet<Item> source, int elementConsumption, int inputSize, int outputSize, double luckRatio, int order, Pattern tagPattern, List<Pattern> patterns, String namespace, Optional<Pattern> namespacePattern) {
        super(source, elementConsumption, inputSize, outputSize, luckRatio, order);
        this.tagPattern = tagPattern;
        this.patterns = patterns;
        this.namespace = namespace;
        this.namespacePattern = namespacePattern;
    }

    public PureOreLoaderType<PatternPureOreLoader> type() {
        return (PureOreLoaderType)PureOreLoaderTypes.PATTERN.get();
    }

    @Override
    protected AbstractPureOreLoader.PureOreTagGroup load(Map<ResourceLocation, LoadedPureOre> pureOres, Holder<Item> ore) {
        Pattern np = this.namespacePattern.orElseGet(() -> Pattern.compile("^" + this.namespace + "$"));
        ResourceKey key = ore.getKey();
        if (key == null) {
            throw new PureOreException("Holder " + String.valueOf(ore) + " has no key");
        }
        ResourceLocation id = key.location();
        List<TagKey<Item>> tags = ore.tags().filter(t -> {
            ResourceLocation location = t.location();
            return np.matcher(location.getNamespace()).find() && this.tagPattern.matcher(location.getPath()).find();
        }).toList();
        if (!tags.isEmpty()) {
            if (tags.size() > 1) {
                Supplier[] supplierArray = new Supplier[4];
                supplierArray[0] = () -> ((ResourceLocation)id).toString();
                supplierArray[1] = np::pattern;
                supplierArray[2] = this.tagPattern::pattern;
                supplierArray[3] = () -> tags.stream().map(t -> t.location().toString()).collect(Collectors.joining(", "));
                ElementalCraftApi.LOGGER.warn("Item {} has multiple tags matching \"{}:{}\":\r\n\t{}", supplierArray);
            }
            id = ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)this.cleanPath(this.tagPattern.matcher(tags.getFirst().location().getPath()).replaceAll("")));
        } else {
            id = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)this.cleanPath(id.getPath()));
        }
        return new AbstractPureOreLoader.PureOreTagGroup(id, tags);
    }

    private String cleanPath(String path) {
        for (Pattern pattern : this.patterns) {
            path = pattern.matcher(path).replaceAll("");
        }
        return path;
    }
}

