/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore.loader;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import sirttas.elementalcraft.pureore.PureOreManager;
import sirttas.elementalcraft.recipe.instrument.io.purification.OrePurificationRecipe;
import sirttas.elementalcraft.tag.ECTags;

public class LoadedPureOre {
    private static final String MINECRAFT = "minecraft";
    private static final String DEEPSLATE = "deepslate";
    private static final Comparator<ResourceLocation> MINECRAFT_NAMESPACE_COMPARATOR = (name1, name2) -> {
        if (MINECRAFT.equals(name1.getNamespace()) && !MINECRAFT.equals(name2.getNamespace())) {
            return -1;
        }
        if (!MINECRAFT.equals(name1.getNamespace()) && MINECRAFT.equals(name2.getNamespace())) {
            return 1;
        }
        return 0;
    };
    private static final Comparator<ResourceLocation> DEEPSLATE_COMPARATOR = (name1, name2) -> {
        if (name1.getPath().contains(DEEPSLATE) && !name2.getPath().contains(DEEPSLATE)) {
            return 1;
        }
        if (!name1.getPath().contains(DEEPSLATE) && name2.getPath().contains(DEEPSLATE)) {
            return -1;
        }
        return 0;
    };
    private static final Comparator<Item> DESCRIPTION_COMPARATOR = Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0), MINECRAFT_NAMESPACE_COMPARATOR.thenComparing(DEEPSLATE_COMPARATOR).thenComparing(ResourceLocation::compareTo));
    private final ResourceLocation id;
    private final Set<Holder<Item>> ores;
    private final Map<RecipeType<?>, Recipe<?>> recipes;
    private ItemStack resultForColor;
    private final int elementConsumption;
    private final int inputSize;
    private final int outputSize;
    private final double luckRatio;

    public LoadedPureOre(ResourceLocation id, int elementConsumption, int inputSize, int outputSize, double luckRatio) {
        this.id = id;
        this.ores = new HashSet<Holder<Item>>();
        this.recipes = new HashMap();
        this.resultForColor = ItemStack.EMPTY;
        this.elementConsumption = elementConsumption;
        this.inputSize = inputSize;
        this.outputSize = outputSize;
        this.luckRatio = luckRatio;
    }

    public Ingredient getInput() {
        return Ingredient.of(this.getOres().stream().map(i -> {
            ItemStack stack = new ItemStack(i);
            stack.setCount(this.inputSize);
            return stack;
        }));
    }

    private ItemStack getOutput() {
        ItemStack result = PureOreManager.getInstance().createPureOre(this.id);
        if (result.isEmpty()) {
            return ItemStack.EMPTY;
        }
        result.setCount(this.outputSize);
        return result;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Set<Holder<Item>> getOres() {
        return this.ores;
    }

    public boolean isProcessable() {
        return !this.ores.isEmpty() && !this.recipes.isEmpty();
    }

    public <C extends RecipeInput, T extends Recipe<C>> T getRecipe(RecipeType<T> recipeType) {
        return (T)this.recipes.get(recipeType);
    }

    public <C extends RecipeInput, T extends Recipe<C>> void addRecipe(@Nonnull T recipe, ItemStack output) {
        this.recipes.computeIfAbsent(recipe.getType(), t -> {
            if (this.resultForColor.isEmpty()) {
                this.resultForColor = output;
            }
            return recipe;
        });
    }

    public void addTag(TagKey<Item> tag) {
        this.addTag(ECTags.Items.getTag(tag));
    }

    public void addTag(HolderSet.Named<Item> tag) {
        tag.forEach(this.ores::add);
    }

    public boolean contains(Holder<Item> item) {
        return this.ores.stream().anyMatch(arg_0 -> item.is(arg_0));
    }

    public OrePurificationRecipe getOrePurificationRecipe() {
        return new OrePurificationRecipe(this.getInput(), this.getOutput(), this.elementConsumption, this.inputSize, this.luckRatio);
    }

    public ItemStack getResultForColor() {
        return this.resultForColor;
    }
}

